/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.servicebinding.rev160406;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.InstructionList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.list.Instruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.servicebinding.rev160406.ServiceOpenflowInfo;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.servicebinding.rev160406.StypeOpenflow;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class StypeOpenflowBuilder
implements Builder<StypeOpenflow> {
    private Short _dispatcherTableId;
    private BigInteger _flowCookie;
    private Integer _flowPriority;
    private List<Instruction> _instruction;
    private static final Range<BigInteger>[] CHECKFLOWCOOKIERANGE_RANGES;

    public StypeOpenflowBuilder() {
    }

    public StypeOpenflowBuilder(ServiceOpenflowInfo arg) {
        this._dispatcherTableId = arg.getDispatcherTableId();
        this._flowPriority = arg.getFlowPriority();
        this._flowCookie = arg.getFlowCookie();
        this._instruction = arg.getInstruction();
    }

    public StypeOpenflowBuilder(InstructionList arg) {
        this._instruction = arg.getInstruction();
    }

    public StypeOpenflowBuilder(StypeOpenflow base) {
        this._dispatcherTableId = base.getDispatcherTableId();
        this._flowCookie = base.getFlowCookie();
        this._flowPriority = base.getFlowPriority();
        this._instruction = base.getInstruction();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ServiceOpenflowInfo) {
            this._dispatcherTableId = ((ServiceOpenflowInfo)arg).getDispatcherTableId();
            this._flowPriority = ((ServiceOpenflowInfo)arg).getFlowPriority();
            this._flowCookie = ((ServiceOpenflowInfo)arg).getFlowCookie();
            isValidArg = true;
        }
        if (arg instanceof InstructionList) {
            this._instruction = ((InstructionList)arg).getInstruction();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.servicebinding.rev160406.ServiceOpenflowInfo, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.InstructionList] \nbut was: " + arg);
        }
    }

    public Short getDispatcherTableId() {
        return this._dispatcherTableId;
    }

    public BigInteger getFlowCookie() {
        return this._flowCookie;
    }

    public Integer getFlowPriority() {
        return this._flowPriority;
    }

    public List<Instruction> getInstruction() {
        return this._instruction;
    }

    private static void checkDispatcherTableIdRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public StypeOpenflowBuilder setDispatcherTableId(Short value) {
        if (value != null) {
            StypeOpenflowBuilder.checkDispatcherTableIdRange(value);
        }
        this._dispatcherTableId = value;
        return this;
    }

    private static void checkFlowCookieRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKFLOWCOOKIERANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKFLOWCOOKIERANGE_RANGES)));
    }

    public StypeOpenflowBuilder setFlowCookie(BigInteger value) {
        if (value != null) {
            StypeOpenflowBuilder.checkFlowCookieRange(value);
        }
        this._flowCookie = value;
        return this;
    }

    private static void checkFlowPriorityRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..65535]].", value));
    }

    public StypeOpenflowBuilder setFlowPriority(Integer value) {
        if (value != null) {
            StypeOpenflowBuilder.checkFlowPriorityRange(value);
        }
        this._flowPriority = value;
        return this;
    }

    public StypeOpenflowBuilder setInstruction(List<Instruction> value) {
        this._instruction = value;
        return this;
    }

    public StypeOpenflow build() {
        return new StypeOpenflowImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKFLOWCOOKIERANGE_RANGES = a;
    }

    private static final class StypeOpenflowImpl
    implements StypeOpenflow {
        private final Short _dispatcherTableId;
        private final BigInteger _flowCookie;
        private final Integer _flowPriority;
        private final List<Instruction> _instruction;
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<StypeOpenflow> getImplementedInterface() {
            return StypeOpenflow.class;
        }

        private StypeOpenflowImpl(StypeOpenflowBuilder base) {
            this._dispatcherTableId = base.getDispatcherTableId();
            this._flowCookie = base.getFlowCookie();
            this._flowPriority = base.getFlowPriority();
            this._instruction = base.getInstruction();
        }

        @Override
        public Short getDispatcherTableId() {
            return this._dispatcherTableId;
        }

        @Override
        public BigInteger getFlowCookie() {
            return this._flowCookie;
        }

        @Override
        public Integer getFlowPriority() {
            return this._flowPriority;
        }

        public List<Instruction> getInstruction() {
            return this._instruction;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._dispatcherTableId);
            result = 31 * result + Objects.hashCode(this._flowCookie);
            result = 31 * result + Objects.hashCode(this._flowPriority);
            this.hash = result = 31 * result + Objects.hashCode(this._instruction);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!StypeOpenflow.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            StypeOpenflow other = (StypeOpenflow)obj;
            if (!Objects.equals(this._dispatcherTableId, other.getDispatcherTableId())) {
                return false;
            }
            if (!Objects.equals(this._flowCookie, other.getFlowCookie())) {
                return false;
            }
            if (!Objects.equals(this._flowPriority, other.getFlowPriority())) {
                return false;
            }
            return Objects.equals(this._instruction, other.getInstruction());
        }

        public String toString() {
            String name = "StypeOpenflow [";
            StringBuilder builder = new StringBuilder(name);
            if (this._dispatcherTableId != null) {
                builder.append("_dispatcherTableId=");
                builder.append(this._dispatcherTableId);
                builder.append(", ");
            }
            if (this._flowCookie != null) {
                builder.append("_flowCookie=");
                builder.append(this._flowCookie);
                builder.append(", ");
            }
            if (this._flowPriority != null) {
                builder.append("_flowPriority=");
                builder.append(this._flowPriority);
                builder.append(", ");
            }
            if (this._instruction != null) {
                builder.append("_instruction=");
                builder.append(this._instruction);
            }
            return builder.append(']').toString();
        }
    }
}

