/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.rpcs.rev160406;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.rpcs.rev160406.GetPortFromInterfaceOutput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GetPortFromInterfaceOutputBuilder
implements Builder<GetPortFromInterfaceOutput> {
    private BigInteger _dpid;
    private String _phyAddress;
    private String _portname;
    private Long _portno;
    Map<Class<? extends Augmentation<GetPortFromInterfaceOutput>>, Augmentation<GetPortFromInterfaceOutput>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKDPIDRANGE_RANGES;

    public GetPortFromInterfaceOutputBuilder() {
    }

    public GetPortFromInterfaceOutputBuilder(GetPortFromInterfaceOutput base) {
        AugmentationHolder casted;
        this._dpid = base.getDpid();
        this._phyAddress = base.getPhyAddress();
        this._portname = base.getPortname();
        this._portno = base.getPortno();
        if (base instanceof GetPortFromInterfaceOutputImpl) {
            GetPortFromInterfaceOutputImpl impl = (GetPortFromInterfaceOutputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<GetPortFromInterfaceOutput>>, Augmentation<GetPortFromInterfaceOutput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GetPortFromInterfaceOutput>>, Augmentation<GetPortFromInterfaceOutput>>(casted.augmentations());
        }
    }

    public BigInteger getDpid() {
        return this._dpid;
    }

    public String getPhyAddress() {
        return this._phyAddress;
    }

    public String getPortname() {
        return this._portname;
    }

    public Long getPortno() {
        return this._portno;
    }

    public <E extends Augmentation<GetPortFromInterfaceOutput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkDpidRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKDPIDRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKDPIDRANGE_RANGES)));
    }

    public GetPortFromInterfaceOutputBuilder setDpid(BigInteger value) {
        if (value != null) {
            GetPortFromInterfaceOutputBuilder.checkDpidRange(value);
        }
        this._dpid = value;
        return this;
    }

    public GetPortFromInterfaceOutputBuilder setPhyAddress(String value) {
        this._phyAddress = value;
        return this;
    }

    public GetPortFromInterfaceOutputBuilder setPortname(String value) {
        this._portname = value;
        return this;
    }

    private static void checkPortnoRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public GetPortFromInterfaceOutputBuilder setPortno(Long value) {
        if (value != null) {
            GetPortFromInterfaceOutputBuilder.checkPortnoRange(value);
        }
        this._portno = value;
        return this;
    }

    public GetPortFromInterfaceOutputBuilder addAugmentation(Class<? extends Augmentation<GetPortFromInterfaceOutput>> augmentationType, Augmentation<GetPortFromInterfaceOutput> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GetPortFromInterfaceOutput>>, Augmentation<GetPortFromInterfaceOutput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public GetPortFromInterfaceOutputBuilder removeAugmentation(Class<? extends Augmentation<GetPortFromInterfaceOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public GetPortFromInterfaceOutput build() {
        return new GetPortFromInterfaceOutputImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKDPIDRANGE_RANGES = a;
    }

    private static final class GetPortFromInterfaceOutputImpl
    implements GetPortFromInterfaceOutput {
        private final BigInteger _dpid;
        private final String _phyAddress;
        private final String _portname;
        private final Long _portno;
        private Map<Class<? extends Augmentation<GetPortFromInterfaceOutput>>, Augmentation<GetPortFromInterfaceOutput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<GetPortFromInterfaceOutput> getImplementedInterface() {
            return GetPortFromInterfaceOutput.class;
        }

        private GetPortFromInterfaceOutputImpl(GetPortFromInterfaceOutputBuilder base) {
            this._dpid = base.getDpid();
            this._phyAddress = base.getPhyAddress();
            this._portname = base.getPortname();
            this._portno = base.getPortno();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<GetPortFromInterfaceOutput>>, Augmentation<GetPortFromInterfaceOutput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<GetPortFromInterfaceOutput>>, Augmentation<GetPortFromInterfaceOutput>>(base.augmentation);
                }
            }
        }

        @Override
        public BigInteger getDpid() {
            return this._dpid;
        }

        @Override
        public String getPhyAddress() {
            return this._phyAddress;
        }

        @Override
        public String getPortname() {
            return this._portname;
        }

        @Override
        public Long getPortno() {
            return this._portno;
        }

        public <E extends Augmentation<GetPortFromInterfaceOutput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._dpid);
            result = 31 * result + Objects.hashCode(this._phyAddress);
            result = 31 * result + Objects.hashCode(this._portname);
            result = 31 * result + Objects.hashCode(this._portno);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!GetPortFromInterfaceOutput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            GetPortFromInterfaceOutput other = (GetPortFromInterfaceOutput)obj;
            if (!Objects.equals(this._dpid, other.getDpid())) {
                return false;
            }
            if (!Objects.equals(this._phyAddress, other.getPhyAddress())) {
                return false;
            }
            if (!Objects.equals(this._portname, other.getPortname())) {
                return false;
            }
            if (!Objects.equals(this._portno, other.getPortno())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                GetPortFromInterfaceOutputImpl otherImpl = (GetPortFromInterfaceOutputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<GetPortFromInterfaceOutput>>, Augmentation<GetPortFromInterfaceOutput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "GetPortFromInterfaceOutput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._dpid != null) {
                builder.append("_dpid=");
                builder.append(this._dpid);
                builder.append(", ");
            }
            if (this._phyAddress != null) {
                builder.append("_phyAddress=");
                builder.append(this._phyAddress);
                builder.append(", ");
            }
            if (this._portname != null) {
                builder.append("_portname=");
                builder.append(this._portname);
                builder.append(", ");
            }
            if (this._portno != null) {
                builder.append("_portno=");
                builder.append(this._portno);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

