/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.rev160406.tunnel.optional.params;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.rev160406.tunnel.optional.params.TunnelOptions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.rev160406.tunnel.optional.params.TunnelOptionsKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TunnelOptionsBuilder
implements Builder<TunnelOptions> {
    private TunnelOptionsKey _key;
    private String _tunnelOption;
    private String _value;
    Map<Class<? extends Augmentation<TunnelOptions>>, Augmentation<TunnelOptions>> augmentation = Collections.emptyMap();

    public TunnelOptionsBuilder() {
    }

    public TunnelOptionsBuilder(TunnelOptions base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new TunnelOptionsKey(base.getTunnelOption());
            this._tunnelOption = base.getTunnelOption();
        } else {
            this._key = base.getKey();
            this._tunnelOption = this._key.getTunnelOption();
        }
        this._value = base.getValue();
        if (base instanceof TunnelOptionsImpl) {
            TunnelOptionsImpl impl = (TunnelOptionsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<TunnelOptions>>, Augmentation<TunnelOptions>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TunnelOptions>>, Augmentation<TunnelOptions>>(casted.augmentations());
        }
    }

    public TunnelOptionsKey getKey() {
        return this._key;
    }

    public String getTunnelOption() {
        return this._tunnelOption;
    }

    public String getValue() {
        return this._value;
    }

    public <E extends Augmentation<TunnelOptions>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public TunnelOptionsBuilder setKey(TunnelOptionsKey value) {
        this._key = value;
        return this;
    }

    public TunnelOptionsBuilder setTunnelOption(String value) {
        this._tunnelOption = value;
        return this;
    }

    public TunnelOptionsBuilder setValue(String value) {
        this._value = value;
        return this;
    }

    public TunnelOptionsBuilder addAugmentation(Class<? extends Augmentation<TunnelOptions>> augmentationType, Augmentation<TunnelOptions> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TunnelOptions>>, Augmentation<TunnelOptions>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public TunnelOptionsBuilder removeAugmentation(Class<? extends Augmentation<TunnelOptions>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public TunnelOptions build() {
        return new TunnelOptionsImpl(this);
    }

    private static final class TunnelOptionsImpl
    implements TunnelOptions {
        private final TunnelOptionsKey _key;
        private final String _tunnelOption;
        private final String _value;
        private Map<Class<? extends Augmentation<TunnelOptions>>, Augmentation<TunnelOptions>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<TunnelOptions> getImplementedInterface() {
            return TunnelOptions.class;
        }

        private TunnelOptionsImpl(TunnelOptionsBuilder base) {
            if (base.getKey() == null) {
                this._key = new TunnelOptionsKey(base.getTunnelOption());
                this._tunnelOption = base.getTunnelOption();
            } else {
                this._key = base.getKey();
                this._tunnelOption = this._key.getTunnelOption();
            }
            this._value = base.getValue();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<TunnelOptions>>, Augmentation<TunnelOptions>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<TunnelOptions>>, Augmentation<TunnelOptions>>(base.augmentation);
                }
            }
        }

        @Override
        public TunnelOptionsKey getKey() {
            return this._key;
        }

        @Override
        public String getTunnelOption() {
            return this._tunnelOption;
        }

        @Override
        public String getValue() {
            return this._value;
        }

        public <E extends Augmentation<TunnelOptions>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._tunnelOption);
            result = 31 * result + Objects.hashCode(this._value);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!TunnelOptions.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            TunnelOptions other = (TunnelOptions)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._tunnelOption, other.getTunnelOption())) {
                return false;
            }
            if (!Objects.equals(this._value, other.getValue())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TunnelOptionsImpl otherImpl = (TunnelOptionsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<TunnelOptions>>, Augmentation<TunnelOptions>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "TunnelOptions [";
            StringBuilder builder = new StringBuilder(name);
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._tunnelOption != null) {
                builder.append("_tunnelOption=");
                builder.append(this._tunnelOption);
                builder.append(", ");
            }
            if (this._value != null) {
                builder.append("_value=");
                builder.append(this._value);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

