/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.rev160406.monitor.params;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.rev160406.monitor.params.MonitorConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.rev160406.monitor.params.MonitorConfigKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MonitorConfigBuilder
implements Builder<MonitorConfig> {
    private MonitorConfigKey _key;
    private String _monitorConfigKey;
    private String _monitorConfigValue;
    Map<Class<? extends Augmentation<MonitorConfig>>, Augmentation<MonitorConfig>> augmentation = Collections.emptyMap();

    public MonitorConfigBuilder() {
    }

    public MonitorConfigBuilder(MonitorConfig base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new MonitorConfigKey(base.getMonitorConfigKey());
            this._monitorConfigKey = base.getMonitorConfigKey();
        } else {
            this._key = base.getKey();
            this._monitorConfigKey = this._key.getMonitorConfigKey();
        }
        this._monitorConfigValue = base.getMonitorConfigValue();
        if (base instanceof MonitorConfigImpl) {
            MonitorConfigImpl impl = (MonitorConfigImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<MonitorConfig>>, Augmentation<MonitorConfig>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MonitorConfig>>, Augmentation<MonitorConfig>>(casted.augmentations());
        }
    }

    public MonitorConfigKey getKey() {
        return this._key;
    }

    public String getMonitorConfigKey() {
        return this._monitorConfigKey;
    }

    public String getMonitorConfigValue() {
        return this._monitorConfigValue;
    }

    public <E extends Augmentation<MonitorConfig>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MonitorConfigBuilder setKey(MonitorConfigKey value) {
        this._key = value;
        return this;
    }

    public MonitorConfigBuilder setMonitorConfigKey(String value) {
        this._monitorConfigKey = value;
        return this;
    }

    public MonitorConfigBuilder setMonitorConfigValue(String value) {
        this._monitorConfigValue = value;
        return this;
    }

    public MonitorConfigBuilder addAugmentation(Class<? extends Augmentation<MonitorConfig>> augmentationType, Augmentation<MonitorConfig> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MonitorConfig>>, Augmentation<MonitorConfig>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public MonitorConfigBuilder removeAugmentation(Class<? extends Augmentation<MonitorConfig>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MonitorConfig build() {
        return new MonitorConfigImpl(this);
    }

    private static final class MonitorConfigImpl
    implements MonitorConfig {
        private final MonitorConfigKey _key;
        private final String _monitorConfigKey;
        private final String _monitorConfigValue;
        private Map<Class<? extends Augmentation<MonitorConfig>>, Augmentation<MonitorConfig>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<MonitorConfig> getImplementedInterface() {
            return MonitorConfig.class;
        }

        private MonitorConfigImpl(MonitorConfigBuilder base) {
            if (base.getKey() == null) {
                this._key = new MonitorConfigKey(base.getMonitorConfigKey());
                this._monitorConfigKey = base.getMonitorConfigKey();
            } else {
                this._key = base.getKey();
                this._monitorConfigKey = this._key.getMonitorConfigKey();
            }
            this._monitorConfigValue = base.getMonitorConfigValue();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<MonitorConfig>>, Augmentation<MonitorConfig>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<MonitorConfig>>, Augmentation<MonitorConfig>>(base.augmentation);
                }
            }
        }

        @Override
        public MonitorConfigKey getKey() {
            return this._key;
        }

        @Override
        public String getMonitorConfigKey() {
            return this._monitorConfigKey;
        }

        @Override
        public String getMonitorConfigValue() {
            return this._monitorConfigValue;
        }

        public <E extends Augmentation<MonitorConfig>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._monitorConfigKey);
            result = 31 * result + Objects.hashCode(this._monitorConfigValue);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MonitorConfig.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            MonitorConfig other = (MonitorConfig)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._monitorConfigKey, other.getMonitorConfigKey())) {
                return false;
            }
            if (!Objects.equals(this._monitorConfigValue, other.getMonitorConfigValue())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MonitorConfigImpl otherImpl = (MonitorConfigImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<MonitorConfig>>, Augmentation<MonitorConfig>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "MonitorConfig [";
            StringBuilder builder = new StringBuilder(name);
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._monitorConfigKey != null) {
                builder.append("_monitorConfigKey=");
                builder.append(this._monitorConfigKey);
                builder.append(", ");
            }
            if (this._monitorConfigValue != null) {
                builder.append("_monitorConfigValue=");
                builder.append(this._monitorConfigValue);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

