/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.rev160406;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.rev160406.ParentRefs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.rev160406.interfaces._interface.NodeIdentifier;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ParentRefsBuilder
implements Builder<ParentRefs> {
    private BigInteger _datapathNodeIdentifier;
    private List<NodeIdentifier> _nodeIdentifier;
    private String _parentInterface;
    private static final Range<BigInteger>[] CHECKDATAPATHNODEIDENTIFIERRANGE_RANGES;

    public ParentRefsBuilder() {
    }

    public ParentRefsBuilder(ParentRefs base) {
        this._datapathNodeIdentifier = base.getDatapathNodeIdentifier();
        this._nodeIdentifier = base.getNodeIdentifier();
        this._parentInterface = base.getParentInterface();
    }

    public BigInteger getDatapathNodeIdentifier() {
        return this._datapathNodeIdentifier;
    }

    public List<NodeIdentifier> getNodeIdentifier() {
        return this._nodeIdentifier;
    }

    public String getParentInterface() {
        return this._parentInterface;
    }

    private static void checkDatapathNodeIdentifierRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKDATAPATHNODEIDENTIFIERRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKDATAPATHNODEIDENTIFIERRANGE_RANGES)));
    }

    public ParentRefsBuilder setDatapathNodeIdentifier(BigInteger value) {
        if (value != null) {
            ParentRefsBuilder.checkDatapathNodeIdentifierRange(value);
        }
        this._datapathNodeIdentifier = value;
        return this;
    }

    public ParentRefsBuilder setNodeIdentifier(List<NodeIdentifier> value) {
        this._nodeIdentifier = value;
        return this;
    }

    public ParentRefsBuilder setParentInterface(String value) {
        this._parentInterface = value;
        return this;
    }

    public ParentRefs build() {
        return new ParentRefsImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKDATAPATHNODEIDENTIFIERRANGE_RANGES = a;
    }

    private static final class ParentRefsImpl
    implements ParentRefs {
        private final BigInteger _datapathNodeIdentifier;
        private final List<NodeIdentifier> _nodeIdentifier;
        private final String _parentInterface;
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ParentRefs> getImplementedInterface() {
            return ParentRefs.class;
        }

        private ParentRefsImpl(ParentRefsBuilder base) {
            this._datapathNodeIdentifier = base.getDatapathNodeIdentifier();
            this._nodeIdentifier = base.getNodeIdentifier();
            this._parentInterface = base.getParentInterface();
        }

        @Override
        public BigInteger getDatapathNodeIdentifier() {
            return this._datapathNodeIdentifier;
        }

        @Override
        public List<NodeIdentifier> getNodeIdentifier() {
            return this._nodeIdentifier;
        }

        @Override
        public String getParentInterface() {
            return this._parentInterface;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._datapathNodeIdentifier);
            result = 31 * result + Objects.hashCode(this._nodeIdentifier);
            this.hash = result = 31 * result + Objects.hashCode(this._parentInterface);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ParentRefs.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ParentRefs other = (ParentRefs)obj;
            if (!Objects.equals(this._datapathNodeIdentifier, other.getDatapathNodeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this._nodeIdentifier, other.getNodeIdentifier())) {
                return false;
            }
            return Objects.equals(this._parentInterface, other.getParentInterface());
        }

        public String toString() {
            String name = "ParentRefs [";
            StringBuilder builder = new StringBuilder(name);
            if (this._datapathNodeIdentifier != null) {
                builder.append("_datapathNodeIdentifier=");
                builder.append(this._datapathNodeIdentifier);
                builder.append(", ");
            }
            if (this._nodeIdentifier != null) {
                builder.append("_nodeIdentifier=");
                builder.append(this._nodeIdentifier);
                builder.append(", ");
            }
            if (this._parentInterface != null) {
                builder.append("_parentInterface=");
                builder.append(this._parentInterface);
            }
            return builder.append(']').toString();
        }
    }
}

