/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.meta.rev160406.dpn.to._interface.list;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.meta.rev160406.dpn.to._interface.list.DpnToInterface;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.meta.rev160406.dpn.to._interface.list.DpnToInterfaceKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.meta.rev160406.dpn.to._interface.list.dpn.to._interface.InterfaceNameEntry;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class DpnToInterfaceBuilder
implements Builder<DpnToInterface> {
    private BigInteger _dpid;
    private List<InterfaceNameEntry> _interfaceNameEntry;
    private DpnToInterfaceKey _key;
    Map<Class<? extends Augmentation<DpnToInterface>>, Augmentation<DpnToInterface>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKDPIDRANGE_RANGES;

    public DpnToInterfaceBuilder() {
    }

    public DpnToInterfaceBuilder(DpnToInterface base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new DpnToInterfaceKey(base.getDpid());
            this._dpid = base.getDpid();
        } else {
            this._key = base.getKey();
            this._dpid = this._key.getDpid();
        }
        this._interfaceNameEntry = base.getInterfaceNameEntry();
        if (base instanceof DpnToInterfaceImpl) {
            DpnToInterfaceImpl impl = (DpnToInterfaceImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<DpnToInterface>>, Augmentation<DpnToInterface>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<DpnToInterface>>, Augmentation<DpnToInterface>>(casted.augmentations());
        }
    }

    public BigInteger getDpid() {
        return this._dpid;
    }

    public List<InterfaceNameEntry> getInterfaceNameEntry() {
        return this._interfaceNameEntry;
    }

    public DpnToInterfaceKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<DpnToInterface>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkDpidRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKDPIDRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKDPIDRANGE_RANGES)));
    }

    public DpnToInterfaceBuilder setDpid(BigInteger value) {
        if (value != null) {
            DpnToInterfaceBuilder.checkDpidRange(value);
        }
        this._dpid = value;
        return this;
    }

    public DpnToInterfaceBuilder setInterfaceNameEntry(List<InterfaceNameEntry> value) {
        this._interfaceNameEntry = value;
        return this;
    }

    public DpnToInterfaceBuilder setKey(DpnToInterfaceKey value) {
        this._key = value;
        return this;
    }

    public DpnToInterfaceBuilder addAugmentation(Class<? extends Augmentation<DpnToInterface>> augmentationType, Augmentation<DpnToInterface> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<DpnToInterface>>, Augmentation<DpnToInterface>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public DpnToInterfaceBuilder removeAugmentation(Class<? extends Augmentation<DpnToInterface>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public DpnToInterface build() {
        return new DpnToInterfaceImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKDPIDRANGE_RANGES = a;
    }

    private static final class DpnToInterfaceImpl
    implements DpnToInterface {
        private final BigInteger _dpid;
        private final List<InterfaceNameEntry> _interfaceNameEntry;
        private final DpnToInterfaceKey _key;
        private Map<Class<? extends Augmentation<DpnToInterface>>, Augmentation<DpnToInterface>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<DpnToInterface> getImplementedInterface() {
            return DpnToInterface.class;
        }

        private DpnToInterfaceImpl(DpnToInterfaceBuilder base) {
            if (base.getKey() == null) {
                this._key = new DpnToInterfaceKey(base.getDpid());
                this._dpid = base.getDpid();
            } else {
                this._key = base.getKey();
                this._dpid = this._key.getDpid();
            }
            this._interfaceNameEntry = base.getInterfaceNameEntry();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<DpnToInterface>>, Augmentation<DpnToInterface>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<DpnToInterface>>, Augmentation<DpnToInterface>>(base.augmentation);
                }
            }
        }

        @Override
        public BigInteger getDpid() {
            return this._dpid;
        }

        @Override
        public List<InterfaceNameEntry> getInterfaceNameEntry() {
            return this._interfaceNameEntry;
        }

        @Override
        public DpnToInterfaceKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<DpnToInterface>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._dpid);
            result = 31 * result + Objects.hashCode(this._interfaceNameEntry);
            result = 31 * result + Objects.hashCode(this._key);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DpnToInterface.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            DpnToInterface other = (DpnToInterface)obj;
            if (!Objects.equals(this._dpid, other.getDpid())) {
                return false;
            }
            if (!Objects.equals(this._interfaceNameEntry, other.getInterfaceNameEntry())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                DpnToInterfaceImpl otherImpl = (DpnToInterfaceImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<DpnToInterface>>, Augmentation<DpnToInterface>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "DpnToInterface [";
            StringBuilder builder = new StringBuilder(name);
            if (this._dpid != null) {
                builder.append("_dpid=");
                builder.append(this._dpid);
                builder.append(", ");
            }
            if (this._interfaceNameEntry != null) {
                builder.append("_interfaceNameEntry=");
                builder.append(this._interfaceNameEntry);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

