/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.meta.rev160406.bridge.ref.info;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.meta.rev160406.bridge.ref.info.BridgeRefEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.meta.rev160406.bridge.ref.info.BridgeRefEntryKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.OvsdbBridgeRef;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class BridgeRefEntryBuilder
implements Builder<BridgeRefEntry> {
    private OvsdbBridgeRef _bridgeReference;
    private BigInteger _dpid;
    private BridgeRefEntryKey _key;
    Map<Class<? extends Augmentation<BridgeRefEntry>>, Augmentation<BridgeRefEntry>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKDPIDRANGE_RANGES;

    public BridgeRefEntryBuilder() {
    }

    public BridgeRefEntryBuilder(BridgeRefEntry base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new BridgeRefEntryKey(base.getDpid());
            this._dpid = base.getDpid();
        } else {
            this._key = base.getKey();
            this._dpid = this._key.getDpid();
        }
        this._bridgeReference = base.getBridgeReference();
        if (base instanceof BridgeRefEntryImpl) {
            BridgeRefEntryImpl impl = (BridgeRefEntryImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<BridgeRefEntry>>, Augmentation<BridgeRefEntry>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BridgeRefEntry>>, Augmentation<BridgeRefEntry>>(casted.augmentations());
        }
    }

    public OvsdbBridgeRef getBridgeReference() {
        return this._bridgeReference;
    }

    public BigInteger getDpid() {
        return this._dpid;
    }

    public BridgeRefEntryKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<BridgeRefEntry>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public BridgeRefEntryBuilder setBridgeReference(OvsdbBridgeRef value) {
        this._bridgeReference = value;
        return this;
    }

    private static void checkDpidRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKDPIDRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKDPIDRANGE_RANGES)));
    }

    public BridgeRefEntryBuilder setDpid(BigInteger value) {
        if (value != null) {
            BridgeRefEntryBuilder.checkDpidRange(value);
        }
        this._dpid = value;
        return this;
    }

    public BridgeRefEntryBuilder setKey(BridgeRefEntryKey value) {
        this._key = value;
        return this;
    }

    public BridgeRefEntryBuilder addAugmentation(Class<? extends Augmentation<BridgeRefEntry>> augmentationType, Augmentation<BridgeRefEntry> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BridgeRefEntry>>, Augmentation<BridgeRefEntry>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public BridgeRefEntryBuilder removeAugmentation(Class<? extends Augmentation<BridgeRefEntry>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public BridgeRefEntry build() {
        return new BridgeRefEntryImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKDPIDRANGE_RANGES = a;
    }

    private static final class BridgeRefEntryImpl
    implements BridgeRefEntry {
        private final OvsdbBridgeRef _bridgeReference;
        private final BigInteger _dpid;
        private final BridgeRefEntryKey _key;
        private Map<Class<? extends Augmentation<BridgeRefEntry>>, Augmentation<BridgeRefEntry>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<BridgeRefEntry> getImplementedInterface() {
            return BridgeRefEntry.class;
        }

        private BridgeRefEntryImpl(BridgeRefEntryBuilder base) {
            if (base.getKey() == null) {
                this._key = new BridgeRefEntryKey(base.getDpid());
                this._dpid = base.getDpid();
            } else {
                this._key = base.getKey();
                this._dpid = this._key.getDpid();
            }
            this._bridgeReference = base.getBridgeReference();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<BridgeRefEntry>>, Augmentation<BridgeRefEntry>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<BridgeRefEntry>>, Augmentation<BridgeRefEntry>>(base.augmentation);
                }
            }
        }

        @Override
        public OvsdbBridgeRef getBridgeReference() {
            return this._bridgeReference;
        }

        @Override
        public BigInteger getDpid() {
            return this._dpid;
        }

        @Override
        public BridgeRefEntryKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<BridgeRefEntry>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bridgeReference);
            result = 31 * result + Objects.hashCode(this._dpid);
            result = 31 * result + Objects.hashCode(this._key);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!BridgeRefEntry.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            BridgeRefEntry other = (BridgeRefEntry)obj;
            if (!Objects.equals(this._bridgeReference, other.getBridgeReference())) {
                return false;
            }
            if (!Objects.equals(this._dpid, other.getDpid())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                BridgeRefEntryImpl otherImpl = (BridgeRefEntryImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<BridgeRefEntry>>, Augmentation<BridgeRefEntry>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "BridgeRefEntry [";
            StringBuilder builder = new StringBuilder(name);
            if (this._bridgeReference != null) {
                builder.append("_bridgeReference=");
                builder.append(this._bridgeReference);
                builder.append(", ");
            }
            if (this._dpid != null) {
                builder.append("_dpid=");
                builder.append(this._dpid);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

