/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.meta.rev160406.bridge._interface.info.bridge.entry;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.meta.rev160406.bridge._interface.info.bridge.entry.BridgeInterfaceEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.meta.rev160406.bridge._interface.info.bridge.entry.BridgeInterfaceEntryKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class BridgeInterfaceEntryBuilder
implements Builder<BridgeInterfaceEntry> {
    private String _interfaceName;
    private BridgeInterfaceEntryKey _key;
    Map<Class<? extends Augmentation<BridgeInterfaceEntry>>, Augmentation<BridgeInterfaceEntry>> augmentation = Collections.emptyMap();

    public BridgeInterfaceEntryBuilder() {
    }

    public BridgeInterfaceEntryBuilder(BridgeInterfaceEntry base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new BridgeInterfaceEntryKey(base.getInterfaceName());
            this._interfaceName = base.getInterfaceName();
        } else {
            this._key = base.getKey();
            this._interfaceName = this._key.getInterfaceName();
        }
        if (base instanceof BridgeInterfaceEntryImpl) {
            BridgeInterfaceEntryImpl impl = (BridgeInterfaceEntryImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<BridgeInterfaceEntry>>, Augmentation<BridgeInterfaceEntry>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BridgeInterfaceEntry>>, Augmentation<BridgeInterfaceEntry>>(casted.augmentations());
        }
    }

    public String getInterfaceName() {
        return this._interfaceName;
    }

    public BridgeInterfaceEntryKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<BridgeInterfaceEntry>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public BridgeInterfaceEntryBuilder setInterfaceName(String value) {
        this._interfaceName = value;
        return this;
    }

    public BridgeInterfaceEntryBuilder setKey(BridgeInterfaceEntryKey value) {
        this._key = value;
        return this;
    }

    public BridgeInterfaceEntryBuilder addAugmentation(Class<? extends Augmentation<BridgeInterfaceEntry>> augmentationType, Augmentation<BridgeInterfaceEntry> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BridgeInterfaceEntry>>, Augmentation<BridgeInterfaceEntry>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public BridgeInterfaceEntryBuilder removeAugmentation(Class<? extends Augmentation<BridgeInterfaceEntry>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public BridgeInterfaceEntry build() {
        return new BridgeInterfaceEntryImpl(this);
    }

    private static final class BridgeInterfaceEntryImpl
    implements BridgeInterfaceEntry {
        private final String _interfaceName;
        private final BridgeInterfaceEntryKey _key;
        private Map<Class<? extends Augmentation<BridgeInterfaceEntry>>, Augmentation<BridgeInterfaceEntry>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<BridgeInterfaceEntry> getImplementedInterface() {
            return BridgeInterfaceEntry.class;
        }

        private BridgeInterfaceEntryImpl(BridgeInterfaceEntryBuilder base) {
            if (base.getKey() == null) {
                this._key = new BridgeInterfaceEntryKey(base.getInterfaceName());
                this._interfaceName = base.getInterfaceName();
            } else {
                this._key = base.getKey();
                this._interfaceName = this._key.getInterfaceName();
            }
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<BridgeInterfaceEntry>>, Augmentation<BridgeInterfaceEntry>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<BridgeInterfaceEntry>>, Augmentation<BridgeInterfaceEntry>>(base.augmentation);
                }
            }
        }

        @Override
        public String getInterfaceName() {
            return this._interfaceName;
        }

        @Override
        public BridgeInterfaceEntryKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<BridgeInterfaceEntry>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._interfaceName);
            result = 31 * result + Objects.hashCode(this._key);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!BridgeInterfaceEntry.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            BridgeInterfaceEntry other = (BridgeInterfaceEntry)obj;
            if (!Objects.equals(this._interfaceName, other.getInterfaceName())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                BridgeInterfaceEntryImpl otherImpl = (BridgeInterfaceEntryImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<BridgeInterfaceEntry>>, Augmentation<BridgeInterfaceEntry>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "BridgeInterfaceEntry [";
            StringBuilder builder = new StringBuilder(name);
            if (this._interfaceName != null) {
                builder.append("_interfaceName=");
                builder.append(this._interfaceName);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

