/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.meta.rev160406._interface.monitor.id.map;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.meta.rev160406._interface.monitor.id.map.InterfaceMonitorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.meta.rev160406._interface.monitor.id.map.InterfaceMonitorIdKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class InterfaceMonitorIdBuilder
implements Builder<InterfaceMonitorId> {
    private String _interfaceName;
    private InterfaceMonitorIdKey _key;
    private List<Long> _monitorId;
    Map<Class<? extends Augmentation<InterfaceMonitorId>>, Augmentation<InterfaceMonitorId>> augmentation = Collections.emptyMap();

    public InterfaceMonitorIdBuilder() {
    }

    public InterfaceMonitorIdBuilder(InterfaceMonitorId base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new InterfaceMonitorIdKey(base.getInterfaceName());
            this._interfaceName = base.getInterfaceName();
        } else {
            this._key = base.getKey();
            this._interfaceName = this._key.getInterfaceName();
        }
        this._monitorId = base.getMonitorId();
        if (base instanceof InterfaceMonitorIdImpl) {
            InterfaceMonitorIdImpl impl = (InterfaceMonitorIdImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceMonitorId>>, Augmentation<InterfaceMonitorId>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceMonitorId>>, Augmentation<InterfaceMonitorId>>(casted.augmentations());
        }
    }

    public String getInterfaceName() {
        return this._interfaceName;
    }

    public InterfaceMonitorIdKey getKey() {
        return this._key;
    }

    public List<Long> getMonitorId() {
        return this._monitorId;
    }

    public <E extends Augmentation<InterfaceMonitorId>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public InterfaceMonitorIdBuilder setInterfaceName(String value) {
        this._interfaceName = value;
        return this;
    }

    public InterfaceMonitorIdBuilder setKey(InterfaceMonitorIdKey value) {
        this._key = value;
        return this;
    }

    public InterfaceMonitorIdBuilder setMonitorId(List<Long> value) {
        this._monitorId = value;
        return this;
    }

    public InterfaceMonitorIdBuilder addAugmentation(Class<? extends Augmentation<InterfaceMonitorId>> augmentationType, Augmentation<InterfaceMonitorId> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceMonitorId>>, Augmentation<InterfaceMonitorId>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public InterfaceMonitorIdBuilder removeAugmentation(Class<? extends Augmentation<InterfaceMonitorId>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public InterfaceMonitorId build() {
        return new InterfaceMonitorIdImpl(this);
    }

    private static final class InterfaceMonitorIdImpl
    implements InterfaceMonitorId {
        private final String _interfaceName;
        private final InterfaceMonitorIdKey _key;
        private final List<Long> _monitorId;
        private Map<Class<? extends Augmentation<InterfaceMonitorId>>, Augmentation<InterfaceMonitorId>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<InterfaceMonitorId> getImplementedInterface() {
            return InterfaceMonitorId.class;
        }

        private InterfaceMonitorIdImpl(InterfaceMonitorIdBuilder base) {
            if (base.getKey() == null) {
                this._key = new InterfaceMonitorIdKey(base.getInterfaceName());
                this._interfaceName = base.getInterfaceName();
            } else {
                this._key = base.getKey();
                this._interfaceName = this._key.getInterfaceName();
            }
            this._monitorId = base.getMonitorId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<InterfaceMonitorId>>, Augmentation<InterfaceMonitorId>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceMonitorId>>, Augmentation<InterfaceMonitorId>>(base.augmentation);
                }
            }
        }

        @Override
        public String getInterfaceName() {
            return this._interfaceName;
        }

        @Override
        public InterfaceMonitorIdKey getKey() {
            return this._key;
        }

        @Override
        public List<Long> getMonitorId() {
            return this._monitorId;
        }

        public <E extends Augmentation<InterfaceMonitorId>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._interfaceName);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._monitorId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!InterfaceMonitorId.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            InterfaceMonitorId other = (InterfaceMonitorId)obj;
            if (!Objects.equals(this._interfaceName, other.getInterfaceName())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._monitorId, other.getMonitorId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                InterfaceMonitorIdImpl otherImpl = (InterfaceMonitorIdImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<InterfaceMonitorId>>, Augmentation<InterfaceMonitorId>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "InterfaceMonitorId [";
            StringBuilder builder = new StringBuilder(name);
            if (this._interfaceName != null) {
                builder.append("_interfaceName=");
                builder.append(this._interfaceName);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._monitorId != null) {
                builder.append("_monitorId=");
                builder.append(this._monitorId);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

