/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.meta.rev160406._interface.child.info;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.meta.rev160406._interface.child.info.InterfaceParentEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.meta.rev160406._interface.child.info.InterfaceParentEntryKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.meta.rev160406._interface.child.info._interface.parent.entry.InterfaceChildEntry;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class InterfaceParentEntryBuilder
implements Builder<InterfaceParentEntry> {
    private List<InterfaceChildEntry> _interfaceChildEntry;
    private InterfaceParentEntryKey _key;
    private String _parentInterface;
    Map<Class<? extends Augmentation<InterfaceParentEntry>>, Augmentation<InterfaceParentEntry>> augmentation = Collections.emptyMap();

    public InterfaceParentEntryBuilder() {
    }

    public InterfaceParentEntryBuilder(InterfaceParentEntry base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new InterfaceParentEntryKey(base.getParentInterface());
            this._parentInterface = base.getParentInterface();
        } else {
            this._key = base.getKey();
            this._parentInterface = this._key.getParentInterface();
        }
        this._interfaceChildEntry = base.getInterfaceChildEntry();
        if (base instanceof InterfaceParentEntryImpl) {
            InterfaceParentEntryImpl impl = (InterfaceParentEntryImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceParentEntry>>, Augmentation<InterfaceParentEntry>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceParentEntry>>, Augmentation<InterfaceParentEntry>>(casted.augmentations());
        }
    }

    public List<InterfaceChildEntry> getInterfaceChildEntry() {
        return this._interfaceChildEntry;
    }

    public InterfaceParentEntryKey getKey() {
        return this._key;
    }

    public String getParentInterface() {
        return this._parentInterface;
    }

    public <E extends Augmentation<InterfaceParentEntry>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public InterfaceParentEntryBuilder setInterfaceChildEntry(List<InterfaceChildEntry> value) {
        this._interfaceChildEntry = value;
        return this;
    }

    public InterfaceParentEntryBuilder setKey(InterfaceParentEntryKey value) {
        this._key = value;
        return this;
    }

    public InterfaceParentEntryBuilder setParentInterface(String value) {
        this._parentInterface = value;
        return this;
    }

    public InterfaceParentEntryBuilder addAugmentation(Class<? extends Augmentation<InterfaceParentEntry>> augmentationType, Augmentation<InterfaceParentEntry> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceParentEntry>>, Augmentation<InterfaceParentEntry>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public InterfaceParentEntryBuilder removeAugmentation(Class<? extends Augmentation<InterfaceParentEntry>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public InterfaceParentEntry build() {
        return new InterfaceParentEntryImpl(this);
    }

    private static final class InterfaceParentEntryImpl
    implements InterfaceParentEntry {
        private final List<InterfaceChildEntry> _interfaceChildEntry;
        private final InterfaceParentEntryKey _key;
        private final String _parentInterface;
        private Map<Class<? extends Augmentation<InterfaceParentEntry>>, Augmentation<InterfaceParentEntry>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<InterfaceParentEntry> getImplementedInterface() {
            return InterfaceParentEntry.class;
        }

        private InterfaceParentEntryImpl(InterfaceParentEntryBuilder base) {
            if (base.getKey() == null) {
                this._key = new InterfaceParentEntryKey(base.getParentInterface());
                this._parentInterface = base.getParentInterface();
            } else {
                this._key = base.getKey();
                this._parentInterface = this._key.getParentInterface();
            }
            this._interfaceChildEntry = base.getInterfaceChildEntry();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<InterfaceParentEntry>>, Augmentation<InterfaceParentEntry>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceParentEntry>>, Augmentation<InterfaceParentEntry>>(base.augmentation);
                }
            }
        }

        @Override
        public List<InterfaceChildEntry> getInterfaceChildEntry() {
            return this._interfaceChildEntry;
        }

        @Override
        public InterfaceParentEntryKey getKey() {
            return this._key;
        }

        @Override
        public String getParentInterface() {
            return this._parentInterface;
        }

        public <E extends Augmentation<InterfaceParentEntry>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._interfaceChildEntry);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._parentInterface);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!InterfaceParentEntry.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            InterfaceParentEntry other = (InterfaceParentEntry)obj;
            if (!Objects.equals(this._interfaceChildEntry, other.getInterfaceChildEntry())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._parentInterface, other.getParentInterface())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                InterfaceParentEntryImpl otherImpl = (InterfaceParentEntryImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<InterfaceParentEntry>>, Augmentation<InterfaceParentEntry>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "InterfaceParentEntry [";
            StringBuilder builder = new StringBuilder(name);
            if (this._interfaceChildEntry != null) {
                builder.append("_interfaceChildEntry=");
                builder.append(this._interfaceChildEntry);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._parentInterface != null) {
                builder.append("_parentInterface=");
                builder.append(this._parentInterface);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

