/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.meta.rev160406;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.meta.rev160406.BridgeInterfaceInfo;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.meta.rev160406.bridge._interface.info.BridgeEntry;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class BridgeInterfaceInfoBuilder
implements Builder<BridgeInterfaceInfo> {
    private List<BridgeEntry> _bridgeEntry;
    Map<Class<? extends Augmentation<BridgeInterfaceInfo>>, Augmentation<BridgeInterfaceInfo>> augmentation = Collections.emptyMap();

    public BridgeInterfaceInfoBuilder() {
    }

    public BridgeInterfaceInfoBuilder(BridgeInterfaceInfo base) {
        AugmentationHolder casted;
        this._bridgeEntry = base.getBridgeEntry();
        if (base instanceof BridgeInterfaceInfoImpl) {
            BridgeInterfaceInfoImpl impl = (BridgeInterfaceInfoImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<BridgeInterfaceInfo>>, Augmentation<BridgeInterfaceInfo>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BridgeInterfaceInfo>>, Augmentation<BridgeInterfaceInfo>>(casted.augmentations());
        }
    }

    public List<BridgeEntry> getBridgeEntry() {
        return this._bridgeEntry;
    }

    public <E extends Augmentation<BridgeInterfaceInfo>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public BridgeInterfaceInfoBuilder setBridgeEntry(List<BridgeEntry> value) {
        this._bridgeEntry = value;
        return this;
    }

    public BridgeInterfaceInfoBuilder addAugmentation(Class<? extends Augmentation<BridgeInterfaceInfo>> augmentationType, Augmentation<BridgeInterfaceInfo> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BridgeInterfaceInfo>>, Augmentation<BridgeInterfaceInfo>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public BridgeInterfaceInfoBuilder removeAugmentation(Class<? extends Augmentation<BridgeInterfaceInfo>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public BridgeInterfaceInfo build() {
        return new BridgeInterfaceInfoImpl(this);
    }

    private static final class BridgeInterfaceInfoImpl
    implements BridgeInterfaceInfo {
        private final List<BridgeEntry> _bridgeEntry;
        private Map<Class<? extends Augmentation<BridgeInterfaceInfo>>, Augmentation<BridgeInterfaceInfo>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<BridgeInterfaceInfo> getImplementedInterface() {
            return BridgeInterfaceInfo.class;
        }

        private BridgeInterfaceInfoImpl(BridgeInterfaceInfoBuilder base) {
            this._bridgeEntry = base.getBridgeEntry();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<BridgeInterfaceInfo>>, Augmentation<BridgeInterfaceInfo>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<BridgeInterfaceInfo>>, Augmentation<BridgeInterfaceInfo>>(base.augmentation);
                }
            }
        }

        @Override
        public List<BridgeEntry> getBridgeEntry() {
            return this._bridgeEntry;
        }

        public <E extends Augmentation<BridgeInterfaceInfo>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bridgeEntry);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!BridgeInterfaceInfo.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            BridgeInterfaceInfo other = (BridgeInterfaceInfo)obj;
            if (!Objects.equals(this._bridgeEntry, other.getBridgeEntry())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                BridgeInterfaceInfoImpl otherImpl = (BridgeInterfaceInfoImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<BridgeInterfaceInfo>>, Augmentation<BridgeInterfaceInfo>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "BridgeInterfaceInfo [";
            StringBuilder builder = new StringBuilder(name);
            if (this._bridgeEntry != null) {
                builder.append("_bridgeEntry=");
                builder.append(this._bridgeEntry);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

