/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.genius.interfacemanager.globals;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.math.BigInteger;
import org.opendaylight.genius.interfacemanager.globals.IfmConstants;

public class InterfaceInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected InterfaceType interfaceType;
    protected int interfaceTag;
    protected BigInteger dpId = IfmConstants.INVALID_DPID;
    protected InterfaceAdminState adminState = InterfaceAdminState.ENABLED;
    protected InterfaceOpState opState;
    protected long groupId;
    protected long l2domainGroupId;
    protected int portNo = -1;
    protected String portName;
    protected String interfaceName;
    protected boolean isUntaggedVlan;
    protected String macAddress;

    public InterfaceInfo(BigInteger dpId, String portName) {
        this.dpId = dpId;
        this.portName = portName;
    }

    public InterfaceInfo(String portName) {
        this.portName = portName;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public boolean isOperational() {
        return this.adminState == InterfaceAdminState.ENABLED && this.opState == InterfaceOpState.UP;
    }

    public InterfaceType getInterfaceType() {
        return this.interfaceType;
    }

    public void setInterfaceType(InterfaceType lportType) {
        this.interfaceType = lportType;
    }

    public int getInterfaceTag() {
        return this.interfaceTag;
    }

    public void setInterfaceTag(int interfaceTag) {
        this.interfaceTag = interfaceTag;
    }

    public void setUntaggedVlan(boolean untaggedVlan) {
        this.isUntaggedVlan = untaggedVlan;
    }

    public boolean isUntaggedVlan() {
        return this.isUntaggedVlan;
    }

    @SuppressFBWarnings(value={"NM_CONFUSING"})
    public BigInteger getDpId() {
        return this.dpId;
    }

    public void setDpId(BigInteger dpId) {
        this.dpId = dpId;
    }

    public InterfaceAdminState getAdminState() {
        return this.adminState;
    }

    public void setAdminState(InterfaceAdminState adminState) {
        this.adminState = adminState;
    }

    public InterfaceOpState getOpState() {
        return this.opState;
    }

    public void setOpState(InterfaceOpState opState) {
        this.opState = opState;
    }

    public long getGroupId() {
        return this.groupId;
    }

    public void setGroupId(long groupId) {
        this.groupId = groupId;
    }

    public long getL2domainGroupId() {
        return this.l2domainGroupId;
    }

    public void setL2domainGroupId(long l2domainGroupId) {
        this.l2domainGroupId = l2domainGroupId;
    }

    public int getPortNo() {
        return this.portNo;
    }

    public void setPortNo(int portNo) {
        this.portNo = portNo;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    @SuppressFBWarnings(value={"NM_CONFUSING"})
    public String getPortName() {
        return this.portName;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public static enum InterfaceOpState {
        UP,
        DOWN,
        UNKNOWN;

    }

    public static enum InterfaceAdminState {
        ENABLED,
        DISABLED;

    }

    public static enum InterfaceType {
        VLAN_INTERFACE,
        VXLAN_TRUNK_INTERFACE,
        GRE_TRUNK_INTERFACE,
        VXLAN_VNI_INTERFACE,
        MPLS_OVER_GRE,
        MPLS_OVER_UDP,
        LOGICAL_GROUP_INTERFACE,
        UNKNOWN_INTERFACE;

    }
}

