/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model;

import java.util.List;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.java.TypeName;

public class TypeDeclaration {
    private final String type;
    private final String name;
    private final List<String> extended;
    private final List<String> implemented;
    private final boolean isAbstract;
    private final boolean isFinal;

    public TypeDeclaration(String type, String name, List<String> extended, List<String> implemented, boolean isAbstract, boolean isFinal) {
        this.type = type;
        this.name = name;
        this.extended = extended;
        this.implemented = implemented;
        this.isAbstract = isAbstract;
        this.isFinal = isFinal;
    }

    public TypeDeclaration(String type, String name, List<String> extended, List<String> implemented) {
        this(type, name, extended, implemented, false, false);
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getExtended() {
        return this.extended;
    }

    public List<String> getImplemented() {
        return this.implemented;
    }

    public TypeName toTypeName() {
        if ("interface".equals(this.type)) {
            return TypeName.interfaceType;
        }
        if ("class".equals(this.type)) {
            if (this.isAbstract) {
                return TypeName.absClassType;
            }
            if (this.isFinal) {
                return TypeName.finalClassType;
            }
            return TypeName.classType;
        }
        if ("enum".equals(this.type)) {
            return TypeName.enumType;
        }
        throw new IllegalStateException("Type not supported: " + this.type);
    }

    public String toString() {
        return "TypeDeclaration{type='" + this.type + '\'' + ", name='" + this.name + '\'' + '}';
    }
}

