/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.controller.config.api.annotations.Description;
import org.opendaylight.controller.config.api.annotations.RequireInterface;
import org.opendaylight.controller.config.api.annotations.ServiceInterfaceAnnotation;
import org.opendaylight.controller.config.yangjmxgenerator.ServiceInterfaceEntry;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.AnnotationSerializer;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Revision;

public class Annotation {
    final String name;
    final List<Parameter> params;
    private static final String quote = "\"";

    public Annotation(String name, List<Parameter> params) {
        this.name = name;
        this.params = params;
    }

    public String getName() {
        return this.name;
    }

    public List<Parameter> getParams() {
        return this.params;
    }

    public static Annotation createFromMap(Class<?> annotationClass, Map<String, String> parameters) {
        ArrayList<Parameter> parameterList = new ArrayList<Parameter>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            parameterList.add(new Parameter(entry.getKey(), entry.getValue()));
        }
        return new Annotation(annotationClass.getCanonicalName(), parameterList);
    }

    public static Annotation createDescriptionAnnotation(String description) {
        Preconditions.checkNotNull((Object)description, (Object)"Cannot create annotation from null description");
        return new Annotation(Description.class.getCanonicalName(), Lists.newArrayList((Object[])new Parameter[]{new Parameter("value", Annotation.q(description))}));
    }

    public static Annotation createModuleQNameANnotation(QName qName) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("namespace", Annotation.q(qName.getNamespace().toString()));
        parameters.put("revision", Annotation.q(qName.getRevision().map(Revision::toString).orElse(null)));
        parameters.put("name", Annotation.q(qName.getLocalName()));
        return Annotation.createFromMap(ModuleQName.class, parameters);
    }

    public static Collection<Annotation> createSieAnnotations(ServiceInterfaceEntry sie) {
        String exportedClassName = sie.getExportedOsgiClassName();
        Preconditions.checkNotNull((Object)sie.getQName(), (Object)"Cannot create annotation from null qname");
        Preconditions.checkNotNull((Object)exportedClassName, (Object)"Cannot create annotation from null exportedClassName");
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        ArrayList<Parameter> params = Lists.newArrayList((Object[])new Parameter[]{new Parameter("value", Annotation.q(sie.getQName().toString()))});
        params.add(new Parameter("osgiRegistrationType", exportedClassName + ".class"));
        params.add(new Parameter("registerToOsgi", Boolean.toString(sie.isRegisterToOsgi())));
        params.add(new Parameter("namespace", Annotation.q(sie.getQName().getNamespace().toString())));
        params.add(new Parameter("revision", Annotation.q(sie.getQName().getRevision().map(Revision::toString).orElse(null))));
        params.add(new Parameter("localName", Annotation.q(sie.getQName().getLocalName())));
        Annotation sieAnnotation = new Annotation(ServiceInterfaceAnnotation.class.getCanonicalName(), (List<Parameter>)params);
        result.add(sieAnnotation);
        params = new ArrayList<Parameter>();
        params.add(new Parameter("namespace", Annotation.q(sie.getYangModuleQName().getNamespace().toString())));
        params.add(new Parameter("revision", Annotation.q(sie.getYangModuleQName().getRevision().map(Revision::toString).orElse(null))));
        params.add(new Parameter("name", Annotation.q(sie.getYangModuleQName().getLocalName())));
        Annotation moduleQNameAnnotation = new Annotation(ModuleQName.class.getCanonicalName(), params);
        result.add(moduleQNameAnnotation);
        return result;
    }

    public static Annotation createRequireIfcAnnotation(ServiceInterfaceEntry sie) {
        String reqIfc = sie.getFullyQualifiedName() + ".class";
        return new Annotation(RequireInterface.class.getCanonicalName(), Lists.newArrayList((Object[])new Parameter[]{new Parameter("value", reqIfc)}));
    }

    public static String q(String nullableDescription) {
        return nullableDescription == null ? null : quote + nullableDescription + quote;
    }

    public String toString() {
        return AnnotationSerializer.toString(this);
    }

    public static class Parameter {
        private final String key;
        private final String value;

        public Parameter(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

