/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.FtlTemplate;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.Annotation;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.Constructor;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.Field;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.Header;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.Method;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.TypeDeclaration;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.util.FullyQualifiedNameHelper;

public abstract class AbstractFtlTemplate
implements FtlTemplate {
    private final String packageName;
    private final List<Field> fields;
    private final List<Annotation> annotations;
    private final List<? extends Method> methods;
    private String javadoc = null;
    private final TypeDeclaration typeDeclaration;
    private final Header header;

    protected AbstractFtlTemplate(Header header, String packageName, List<Field> fields, List<? extends Method> methods, TypeDeclaration typeDeclaration) {
        this.packageName = packageName;
        this.fields = fields;
        this.methods = methods;
        this.annotations = Lists.newArrayList();
        this.typeDeclaration = typeDeclaration;
        this.header = header;
    }

    @Override
    public Header getHeader() {
        return this.header;
    }

    @Override
    public Optional<String> getHeaderString() {
        if (this.header == null) {
            return Optional.absent();
        }
        return Optional.of((Object)this.header.toString());
    }

    @Override
    public String getFullyQualifiedName() {
        return FullyQualifiedNameHelper.getFullyQualifiedName((String)this.getPackageName(), (String)this.getTypeDeclaration().getName());
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public TypeDeclaration getTypeDeclaration() {
        return this.typeDeclaration;
    }

    @Override
    public Optional<String> getMaybeJavadoc() {
        if (this.javadoc == null) {
            return Optional.absent();
        }
        return Optional.of((Object)this.javadoc);
    }

    public void setJavadoc(String javadoc) {
        this.javadoc = javadoc;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public List<Field> getFields() {
        return this.fields;
    }

    @Override
    public List<? extends Method> getMethods() {
        return this.methods;
    }

    @Override
    public List<Constructor> getConstructors() {
        return Collections.emptyList();
    }

    public String toString() {
        return "AbstractFtlTemplate{typeDeclaration=" + this.typeDeclaration + ", packageName='" + this.packageName + '\'' + '}';
    }
}

