/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.plugin.gofactory;

import com.google.common.base.Optional;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.FtlTemplate;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.Annotation;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.Constructor;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.Field;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.Method;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.java.FullyQualifiedName;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.java.GeneratedObject;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.java.GeneratedObjectBuilder;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.java.JavaFileInputBuilder;

public class GenericGeneratedObjectFactory {
    public GeneratedObject toGeneratedObject(FtlTemplate template, Optional<String> copyright) {
        JavaFileInputBuilder b = new JavaFileInputBuilder();
        b.setHeader(template.getHeaderString());
        b.setFqn(new FullyQualifiedName(template.getPackageName(), template.getTypeDeclaration().getName()));
        b.setClassJavaDoc(template.getMaybeJavadoc());
        for (Annotation annotation : template.getAnnotations()) {
            b.addClassAnnotation(annotation);
        }
        for (String string : template.getTypeDeclaration().getExtended()) {
            b.addExtendsFQN(FullyQualifiedName.fromString(string));
        }
        for (String string : template.getTypeDeclaration().getImplemented()) {
            b.addImplementsFQN(FullyQualifiedName.fromString(string));
        }
        b.setCopyright(copyright);
        b.setTypeName(template.getTypeDeclaration().toTypeName());
        for (Field field : template.getFields()) {
            b.addToBody(field.toString());
        }
        for (Constructor constructor : template.getConstructors()) {
            b.addToBody(constructor.toString());
        }
        for (Method method : template.getMethods()) {
            b.addToBody(method.toString());
        }
        return new GeneratedObjectBuilder(b.build()).toGeneratedObject();
    }
}

