/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.plugin;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opendaylight.controller.config.yangjmxgenerator.ModuleMXBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.RuntimeBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.ServiceInterfaceEntry;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.FtlTemplate;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.GeneralClassTemplate;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.GeneralInterfaceTemplate;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.RuntimeRegistratorFtlTemplate;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.StubFactoryTemplate;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.TemplateFactory;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.gofactory.AbsFactoryGeneratedObjectFactory;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.gofactory.AbsModuleGeneratedObjectFactory;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.gofactory.ConcreteModuleGeneratedObjectFactory;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.gofactory.GenericGeneratedObjectFactory;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.java.FullyQualifiedName;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.java.GeneratedObject;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CodeWriter {
    private static final Logger LOG = LoggerFactory.getLogger(CodeWriter.class);
    private static final Optional<String> COPYRIGHT = StringUtil.loadCopyright();

    CodeWriter() {
    }

    public File writeSie(ServiceInterfaceEntry sie, File outputBaseDir) {
        try {
            GeneralInterfaceTemplate generalInterfaceTemplate = TemplateFactory.serviceInterfaceFromSie(sie);
            GeneratedObject go = new GenericGeneratedObjectFactory().toGeneratedObject(generalInterfaceTemplate, COPYRIGHT);
            return (File)((Map.Entry)go.persist(outputBaseDir).get()).getValue();
        }
        catch (Exception e) {
            String message = "An error occurred during Service interface generating, sie:" + sie.getTypeName() + ", " + sie.getFullyQualifiedName();
            LOG.error(message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
    }

    public List<File> writeMbe(ModuleMXBeanEntry mbe, File targetBaseDir, File mainBaseDir) {
        try {
            ArrayList generatedFiles = Lists.newArrayList();
            HashMap<GeneratedObject, Boolean> gos = new HashMap<GeneratedObject, Boolean>();
            Map<String, GeneralClassTemplate> tosFromMbe = TemplateFactory.tOsFromMbe(mbe);
            for (GeneralClassTemplate template : tosFromMbe.values()) {
                gos.put(new GenericGeneratedObjectFactory().toGeneratedObject(template, COPYRIGHT), true);
            }
            GeneralInterfaceTemplate ifcTemplate = TemplateFactory.mXBeanInterfaceTemplateFromMbe(mbe);
            gos.put(new GenericGeneratedObjectFactory().toGeneratedObject(ifcTemplate, COPYRIGHT), true);
            gos.put(new AbsFactoryGeneratedObjectFactory().toGeneratedObject(mbe, COPYRIGHT), true);
            gos.put(new AbsModuleGeneratedObjectFactory().toGeneratedObject(mbe, COPYRIGHT), true);
            StubFactoryTemplate concreteFactory = TemplateFactory.stubFactoryTemplateFromMbe(mbe);
            gos.put(new GenericGeneratedObjectFactory().toGeneratedObject(concreteFactory, COPYRIGHT), false);
            gos.put(new ConcreteModuleGeneratedObjectFactory().toGeneratedObject(mbe, COPYRIGHT, (Optional<String>)Optional.absent()), false);
            List<FtlTemplate> allFtlFiles = CodeWriter.getRuntimeBeanFtlTemplates(mbe.getRuntimeBeans());
            for (FtlTemplate template : allFtlFiles) {
                gos.put(new GenericGeneratedObjectFactory().toGeneratedObject(template, COPYRIGHT), true);
            }
            generatedFiles.addAll(CodeWriter.persistGeneratedObjects(targetBaseDir, mainBaseDir, gos));
            Iterator it = generatedFiles.iterator();
            while (it.hasNext()) {
                if (it.next() != null) continue;
                it.remove();
            }
            return generatedFiles;
        }
        catch (Exception e) {
            String message = "An error occurred during Module generating, mbe:" + mbe.getJavaNamePrefix();
            LOG.error(message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
    }

    private static List<File> persistGeneratedObjects(File targetBaseDir, File mainBaseDir, Map<GeneratedObject, Boolean> gos) throws IOException {
        ArrayList<File> generatedFiles = new ArrayList<File>();
        for (Map.Entry<GeneratedObject, Boolean> entry : gos.entrySet()) {
            boolean overwrite = entry.getValue();
            File dst = overwrite ? targetBaseDir : mainBaseDir;
            Optional<Map.Entry<FullyQualifiedName, File>> maybePersistEntry = entry.getKey().persist(dst, overwrite);
            if (!maybePersistEntry.isPresent()) continue;
            generatedFiles.add((File)((Map.Entry)maybePersistEntry.get()).getValue());
        }
        return generatedFiles;
    }

    private static List<FtlTemplate> getRuntimeBeanFtlTemplates(Collection<RuntimeBeanEntry> runtimeBeans) {
        if (runtimeBeans.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<FtlTemplate> allFtlFiles = new ArrayList<FtlTemplate>();
        Map<String, FtlTemplate> registratorNamesToFtls = RuntimeRegistratorFtlTemplate.create(RuntimeRegistratorFtlTemplate.findRoot(runtimeBeans));
        allFtlFiles.addAll(registratorNamesToFtls.values());
        for (RuntimeBeanEntry runtimeBeanEntry : runtimeBeans) {
            Collection<FtlTemplate> ftlFiles = TemplateFactory.getTOAndMXInterfaceFtlFiles(runtimeBeanEntry).values();
            allFtlFiles.addAll(ftlFiles);
        }
        return allFtlFiles;
    }
}

