/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.plugin.gofactory;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.Description;
import org.opendaylight.controller.config.api.runtime.RootRuntimeBeanRegistrator;
import org.opendaylight.controller.config.yangjmxgenerator.ModuleMXBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.AbstractModuleTemplate;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.TemplateFactory;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.Annotation;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.IdentityRefModuleField;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.Method;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.ModuleField;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.java.FullyQualifiedName;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.java.GeneratedObject;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.java.GeneratedObjectBuilder;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.java.JavaFileInputBuilder;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.java.TypeName;
import org.opendaylight.yangtools.yang.common.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbsModuleGeneratedObjectFactory {
    public GeneratedObject toGeneratedObject(ModuleMXBeanEntry mbe, Optional<String> copyright) {
        FullyQualifiedName abstractFQN = new FullyQualifiedName(mbe.getPackageName(), mbe.getAbstractModuleName());
        Optional classJavaDoc = Optional.fromNullable((Object)mbe.getNullableDescription());
        AbstractModuleTemplate abstractModuleTemplate = TemplateFactory.abstractModuleTemplateFromMbe(mbe);
        Optional<String> header = abstractModuleTemplate.getHeaderString();
        ArrayList<FullyQualifiedName> implementedInterfaces = new ArrayList<FullyQualifiedName>();
        for (String implemented : abstractModuleTemplate.getTypeDeclaration().getImplemented()) {
            implementedInterfaces.add(FullyQualifiedName.fromString(implemented));
        }
        Optional maybeRegistratorType = abstractModuleTemplate.isRuntime() ? Optional.of((Object)FullyQualifiedName.fromString(abstractModuleTemplate.getRegistratorType())) : Optional.absent();
        return this.toGeneratedObject(abstractFQN, copyright, header, (Optional<String>)classJavaDoc, implementedInterfaces, abstractModuleTemplate.getModuleFields(), (Optional<FullyQualifiedName>)maybeRegistratorType, abstractModuleTemplate.getMethods(), mbe.getYangModuleQName());
    }

    public GeneratedObject toGeneratedObject(FullyQualifiedName abstractFQN, Optional<String> copyright, Optional<String> header, Optional<String> classJavaDoc, List<FullyQualifiedName> implementedInterfaces, List<ModuleField> moduleFields, Optional<FullyQualifiedName> maybeRegistratorType, List<? extends Method> methods, QName yangModuleQName) {
        JavaFileInputBuilder b = new JavaFileInputBuilder();
        Annotation moduleQNameAnnotation = Annotation.createModuleQNameANnotation(yangModuleQName);
        b.addClassAnnotation(moduleQNameAnnotation);
        b.setFqn(abstractFQN);
        b.setTypeName(TypeName.absClassType);
        b.setCopyright(copyright);
        b.setHeader(header);
        b.setClassJavaDoc(classJavaDoc);
        for (FullyQualifiedName implemented : implementedInterfaces) {
            b.addImplementsFQN(implemented);
        }
        if (classJavaDoc.isPresent()) {
            b.addClassAnnotation(String.format("@%s(value=\"%s\")", Description.class.getCanonicalName(), classJavaDoc.get()));
        }
        b.addToBody(AbsModuleGeneratedObjectFactory.getLogger(abstractFQN));
        b.addToBody("//attributes start");
        for (ModuleField moduleField : moduleFields) {
            b.addToBody(moduleField.toString() + "\n");
        }
        b.addToBody("//attributes end");
        b.addToBody(AbsModuleGeneratedObjectFactory.getCommonFields(abstractFQN));
        b.addToBody(AbsModuleGeneratedObjectFactory.getNewConstructor(abstractFQN));
        b.addToBody(AbsModuleGeneratedObjectFactory.getCopyFromOldConstructor(abstractFQN));
        b.addToBody(AbsModuleGeneratedObjectFactory.getRuntimeRegistratorCode(maybeRegistratorType));
        b.addToBody(AbsModuleGeneratedObjectFactory.getValidationMethods(moduleFields));
        b.addToBody(AbsModuleGeneratedObjectFactory.getCachesOfResolvedDependencies(moduleFields));
        b.addToBody(AbsModuleGeneratedObjectFactory.getCachesOfResolvedIdentityRefs(moduleFields));
        b.addToBody(AbsModuleGeneratedObjectFactory.getGetInstance(moduleFields));
        b.addToBody(AbsModuleGeneratedObjectFactory.getReuseLogic(moduleFields, abstractFQN));
        b.addToBody(AbsModuleGeneratedObjectFactory.getEqualsAndHashCode(abstractFQN));
        b.addToBody(AbsModuleGeneratedObjectFactory.getMethods(methods));
        return new GeneratedObjectBuilder(b.build()).toGeneratedObject();
    }

    private static String getMethods(List<? extends Method> methods) {
        String result = "\n// getters and setters\n";
        for (Method method : methods) {
            result = result + method.toString() + "\n";
        }
        return result;
    }

    private static String getEqualsAndHashCode(FullyQualifiedName abstractFQN) {
        return "\n@Override\npublic boolean equals(Object o) {\nif (this == o) return true;\nif (o == null || getClass() != o.getClass()) return false;\n" + String.format("%s that = (%1$s) o;\n", abstractFQN.getTypeName()) + "return identifier.equals(that.identifier);\n" + "}\n" + "\n" + "@Override\n" + "public int hashCode() {\n" + "return identifier.hashCode();\n" + "}\n";
    }

    private static String getReuseLogic(List<ModuleField> moduleFields, FullyQualifiedName abstractFQN) {
        String result = "\n" + String.format("public boolean canReuseInstance(%s oldModule){\n", abstractFQN.getTypeName()) + "// allow reusing of old instance if no parameters was changed\n" + "return isSame(oldModule);\n" + "}\n" + "\n" + String.format("public %s reuseInstance(%1$s oldInstance){\n", AutoCloseable.class.getCanonicalName()) + "// implement if instance reuse should be supported. Override canReuseInstance to change the criteria.\n" + "return oldInstance;\n" + "}\n";
        result = result + "\n" + String.format("public boolean isSame(%s other) {\n", abstractFQN.getTypeName()) + "if (other == null) {\n" + "throw new IllegalArgumentException(\"Parameter 'other' is null\");\n" + "}\n";
        for (ModuleField moduleField : moduleFields) {
            if (moduleField.isListOfDependencies()) {
                result = result + String.format("if (%1$sDependency.equals(other.%1$sDependency) == false) {\nreturn false;\n}\nfor (int idx = 0; idx < %1$sDependency.size(); idx++) {\nif (%1$sDependency.get(idx) != other.%1$sDependency.get(idx)) {\nreturn false;\n}\n}\n", moduleField.getName());
                continue;
            }
            if (moduleField.isDependent()) {
                result = result + String.format("if (%sDependency != other.%1$sDependency) { // reference to dependency must be same\nreturn false;\n}\n", moduleField.getName());
                continue;
            }
            result = result + String.format("if (java.util.Objects.deepEquals(%s, other.%1$s) == false) {\nreturn false;\n}\n", moduleField.getName());
        }
        result = result + "\nreturn true;\n}\n";
        return result;
    }

    private static String getGetInstance(List<ModuleField> moduleFields) {
        String result = "\n@Override\n" + String.format("public final %s getInstance() {\n", AutoCloseable.class.getCanonicalName()) + "if(instance==null) {\n";
        HashMap<ModuleField, String> resolveDependenciesMap = new HashMap<ModuleField, String>();
        for (ModuleField moduleField : moduleFields) {
            if (!moduleField.isDependent()) continue;
            String osgi = moduleField.getDependency().getSie().getExportedOsgiClassName();
            String str = moduleField.isList() ? String.format("%sDependency = new java.util.ArrayList<%s>();\nfor(javax.management.ObjectName dep : %1$s) {\n%1$sDependency.add(dependencyResolver.resolveInstance(%2$s.class, dep, %1$sJmxAttribute));\n}\n", moduleField.getName(), osgi) : String.format("%1$sDependency = dependencyResolver.resolveInstance(%2$s.class, %1$s, %1$sJmxAttribute);\n", moduleField.getName(), osgi);
            resolveDependenciesMap.put(moduleField, str);
        }
        for (Map.Entry entry : resolveDependenciesMap.entrySet()) {
            if (!((ModuleField)entry.getKey()).getDependency().isMandatory()) {
                Preconditions.checkState((boolean)((String)entry.getValue()).endsWith(";\n"));
                result = result + String.format("if (%s!=null) {\n%s}\n", ((ModuleField)entry.getKey()).getName(), entry.getValue());
                continue;
            }
            result = result + (String)entry.getValue();
        }
        for (ModuleField moduleField : moduleFields) {
            if (!moduleField.isNeedsDepResolver()) continue;
            result = result + String.format("if (%s!=null){\n", moduleField.getName());
            result = moduleField.isList() ? result + String.format("for(%s candidate : %s) {\ncandidate.injectDependencyResolver(dependencyResolver);\n}\n", moduleField.getGenericInnerType(), moduleField.getName()) : result + String.format("%s.injectDependencyResolver(dependencyResolver);\n", moduleField.getName());
            result = result + "}\n";
        }
        for (ModuleField moduleField : moduleFields) {
            if (!moduleField.isIdentityRef()) continue;
            result = result + String.format("if (%s!=null) {", moduleField.getName());
            result = result + String.format("set%s(%s.resolveIdentity(dependencyResolver, %s.class));", moduleField.getAttributeName(), moduleField.getName(), ((IdentityRefModuleField)moduleField).getIdentityBaseClass());
            result = result + "}\n";
        }
        result = result + "if(oldInstance!=null && canReuseInstance(oldModule)) {\ninstance = reuseInstance(oldInstance);\n} else {\nif(oldInstance!=null) {\ntry {\noldInstance.close();\n} catch(Exception e) {\nlogger.error(\"An error occurred while closing old instance \" + oldInstance, e);\n}\n}\ninstance = createInstance();\nif (instance == null) {\nthrow new IllegalStateException(\"Error in createInstance - null is not allowed as return value\");\n}\n}\n}\nreturn instance;\n}\n" + String.format("public abstract %s createInstance();\n", AutoCloseable.class.getCanonicalName());
        return result;
    }

    private static String getCommonFields(FullyQualifiedName abstractFQN) {
        return "\n" + String.format("private final %s oldModule;\n", abstractFQN.getTypeName()) + String.format("private final %s oldInstance;\n", AutoCloseable.class.getCanonicalName()) + String.format("private %s instance;\n", AutoCloseable.class.getCanonicalName()) + String.format("protected final %s dependencyResolver;\n", DependencyResolver.class.getCanonicalName()) + String.format("private final %s identifier;\n", ModuleIdentifier.class.getCanonicalName()) + "@Override\n" + String.format("public %s getIdentifier() {\n", ModuleIdentifier.class.getCanonicalName()) + "return identifier;\n" + "}\n";
    }

    private static String getCachesOfResolvedIdentityRefs(List<ModuleField> moduleFields) {
        StringBuilder result = new StringBuilder();
        for (ModuleField moduleField : moduleFields) {
            if (!moduleField.isIdentityRef()) continue;
            IdentityRefModuleField field = (IdentityRefModuleField)moduleField;
            result.append(String.format("private %s %s;\n", field.getIdentityClassType(), field.getIdentityClassName()));
        }
        return result.toString();
    }

    private static String getCachesOfResolvedDependencies(List<ModuleField> moduleFields) {
        StringBuilder result = new StringBuilder();
        for (ModuleField moduleField : moduleFields) {
            if (!moduleField.isDependent()) continue;
            String osgi = moduleField.getDependency().getSie().getExportedOsgiClassName();
            if (moduleField.isList()) {
                result.append(String.format("private java.util.List<%s> %sDependency = new java.util.ArrayList<%s>();", osgi, moduleField.getName(), osgi)).append(String.format("protected final java.util.List<%s> get%sDependency(){\n", osgi, moduleField.getAttributeName())).append(String.format("return %sDependency;\n", moduleField.getName())).append("}\n");
                continue;
            }
            result.append(String.format("private %s %sDependency;\nprotected final %s get%sDependency(){\nreturn %sDependency;\n}", osgi, moduleField.getName(), osgi, moduleField.getAttributeName(), moduleField.getName()));
        }
        return result.toString();
    }

    private static String getRuntimeRegistratorCode(Optional<FullyQualifiedName> maybeRegistratorType) {
        if (maybeRegistratorType.isPresent()) {
            String registratorType = ((FullyQualifiedName)maybeRegistratorType.get()).toString();
            return "\n" + String.format("private %s rootRuntimeBeanRegistratorWrapper;\n", registratorType) + "\n" + String.format("public %s getRootRuntimeBeanRegistratorWrapper(){\n", registratorType) + "return rootRuntimeBeanRegistratorWrapper;\n" + "}\n" + "\n" + "@Override\n" + String.format("public void setRuntimeBeanRegistrator(%s rootRuntimeRegistrator){\n", RootRuntimeBeanRegistrator.class.getCanonicalName()) + String.format("this.rootRuntimeBeanRegistratorWrapper = new %s(rootRuntimeRegistrator);\n", registratorType) + "}\n";
        }
        return "";
    }

    private static String getValidationMethods(List<ModuleField> moduleFields) {
        String result = "\n@Override\npublic void validate() {\n";
        for (ModuleField moduleField : moduleFields) {
            if (!moduleField.isDependent() || !moduleField.getDependency().isMandatory()) continue;
            if (moduleField.isList()) {
                result = result + "" + String.format("for(javax.management.ObjectName dep : %s) {\n", moduleField.getName()) + String.format("    dependencyResolver.validateDependency(%s.class, dep, %sJmxAttribute);\n", moduleField.getDependency().getSie().getFullyQualifiedName(), moduleField.getName()) + "}\n";
                continue;
            }
            result = result + String.format("dependencyResolver.validateDependency(%s.class, %s, %sJmxAttribute);", moduleField.getDependency().getSie().getFullyQualifiedName(), moduleField.getName(), moduleField.getName());
        }
        result = result + "\ncustomValidation();\n}\n\nprotected void customValidation() {\n}\n";
        return result;
    }

    private static String getLogger(FullyQualifiedName fqn) {
        return String.format("private static final %s logger = %s.getLogger(%s.class);", Logger.class.getCanonicalName(), LoggerFactory.class.getCanonicalName(), fqn);
    }

    private static String getConstructorStart(FullyQualifiedName fqn, LinkedHashMap<String, String> parameters, String after) {
        String paramString = Joiner.on((String)",").withKeyValueSeparator(" ").join(parameters);
        String setters = "";
        for (String paramName : parameters.values()) {
            setters = setters + String.format("this.%s = %1$s;\n", paramName);
        }
        return String.format("public %s(", fqn.getTypeName()) + paramString + ") {\n" + setters + after + "}\n";
    }

    private static String getNewConstructor(FullyQualifiedName abstractFQN) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put(ModuleIdentifier.class.getCanonicalName(), "identifier");
        parameters.put(DependencyResolver.class.getCanonicalName(), "dependencyResolver");
        String setToNulls = "this.oldInstance=null;\nthis.oldModule=null;\n";
        return AbsModuleGeneratedObjectFactory.getConstructorStart(abstractFQN, parameters, setToNulls);
    }

    private static String getCopyFromOldConstructor(FullyQualifiedName abstractFQN) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put(ModuleIdentifier.class.getCanonicalName(), "identifier");
        parameters.put(DependencyResolver.class.getCanonicalName(), "dependencyResolver");
        parameters.put(abstractFQN.getTypeName(), "oldModule");
        parameters.put(AutoCloseable.class.getCanonicalName(), "oldInstance");
        return AbsModuleGeneratedObjectFactory.getConstructorStart(abstractFQN, parameters, "");
    }
}

