/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.directives;

import com.google.common.collect.Lists;
import freemarker.core.Environment;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.AbstractModuleTemplate;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.ModuleField;

public class ModuleFieldsDirective
implements TemplateDirectiveModel {
    private static final String OBJECT = "moduleFields";

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        Object object = params.get(OBJECT);
        List<Object> fields = Lists.newArrayList();
        if (object != null) {
            if (object instanceof SimpleSequence) {
                fields = ((SimpleSequence)object).toList();
            } else if (object instanceof AbstractModuleTemplate) {
                fields = ((AbstractModuleTemplate)object).getModuleFields();
            } else {
                throw new IllegalArgumentException("Object must be a SimpleSequence or instance of " + AbstractModuleTemplate.class + "but was " + object.getClass());
            }
        }
        Writer out = env.getOut();
        StringBuilder build = new StringBuilder();
        for (ModuleField moduleField : fields) {
            build.append("    ");
            build.append("protected final " + JmxAttribute.class.getCanonicalName() + " " + moduleField.getName() + "JmxAttribute = new " + JmxAttribute.class.getCanonicalName() + "(\"" + moduleField.getAttributeName() + "\");");
            build.append(System.lineSeparator());
            build.append("     private ");
            for (String mod : moduleField.getModifiers()) {
                build.append(mod + " ");
            }
            build.append(moduleField.getType() + " ");
            build.append(moduleField.getName());
            if (moduleField.getNullableDefault() != null) {
                build.append(" = " + moduleField.getNullableDefault());
            }
            build.append(";");
            if (moduleField.isDependent()) {
                String comment = moduleField.getDependency().isMandatory() ? "mandatory" : "optional";
                build.append(" // " + comment);
            }
            build.append(System.lineSeparator());
            build.append(System.lineSeparator());
        }
        if (!fields.isEmpty()) {
            out.write(build.toString().toCharArray());
        }
    }
}

