/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl;

import com.google.common.annotations.VisibleForTesting;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateModel;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.JMXGenerator;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.FtlTemplate;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.directives.AnnotationsDirective;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.directives.ConstructorsDirective;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.directives.FieldsDirectiveProg;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.directives.HeaderDirective;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.directives.JavadocDirective;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.directives.MethodsDirective;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.directives.ModuleFieldsDirective;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.directives.TypeDeclarationDirective;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.directives.UnimplementedExceptionDirective;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtlFilePersister {
    private static final Logger logger = LoggerFactory.getLogger(FtlFilePersister.class);
    private static final Pattern TRAILING_WHITESPACES = Pattern.compile(" +$", 8);

    @VisibleForTesting
    public Map<FtlTemplate, String> serializeFtls(Collection<? extends FtlTemplate> ftlFiles) {
        HashMap<FtlTemplate, String> result = new HashMap<FtlTemplate, String>();
        for (FtlTemplate ftlTemplate : ftlFiles) {
            try {
                StringWriter writer = new StringWriter();
                Throwable throwable = null;
                try {
                    Template template = this.getCfg().getTemplate(ftlTemplate.getFtlTempleteLocation());
                    try {
                        template.process((Object)ftlTemplate, (Writer)writer);
                    }
                    catch (Throwable e) {
                        throw new IllegalStateException("Template error while generating " + ftlTemplate, e);
                    }
                    String fileContent = ((Object)writer).toString();
                    fileContent = TRAILING_WHITESPACES.matcher(fileContent).replaceAll("");
                    result.put(ftlTemplate, fileContent);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    ((Writer)writer).close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Exception while processing template", e);
            }
        }
        return result;
    }

    public List<File> persist(Collection<? extends FtlTemplate> ftlFiles, File dstFolder, boolean overwrite) throws IOException {
        Map<FtlTemplate, String> ftlFileStringMap = this.serializeFtls(ftlFiles);
        ArrayList<File> result = new ArrayList<File>();
        for (Map.Entry<FtlTemplate, String> entry : ftlFileStringMap.entrySet()) {
            FtlTemplate ftlFile = entry.getKey();
            File targetFile = new File(dstFolder, ftlFile.getRelativeFile().getPath());
            File pathToFile = targetFile.getParentFile();
            if (!pathToFile.exists()) {
                pathToFile.mkdirs();
            }
            if (targetFile.exists() && !overwrite) {
                logger.trace("Skipping {} since it already exists", (Object)targetFile);
                continue;
            }
            try (FileWriter fileWriter = new FileWriter(targetFile);){
                fileWriter.write(entry.getValue());
            }
            logger.trace("{}: File {} generated successfully", (Object)JMXGenerator.class.getCanonicalName(), (Object)targetFile);
            result.add(targetFile);
        }
        return result;
    }

    private Configuration getCfg() {
        Configuration cfg = new Configuration();
        cfg.setClassForTemplateLoading(this.getClass(), "/freeMarker/");
        cfg.setSharedVariable("javadocD", (TemplateModel)new JavadocDirective());
        cfg.setSharedVariable("annotationsD", (TemplateModel)new AnnotationsDirective());
        cfg.setSharedVariable("typeDeclarationD", (TemplateModel)new TypeDeclarationDirective());
        cfg.setSharedVariable("constructorsD", (TemplateModel)new ConstructorsDirective());
        cfg.setSharedVariable("fieldsD", (TemplateModel)new FieldsDirectiveProg());
        cfg.setSharedVariable("moduleFieldsD", (TemplateModel)new ModuleFieldsDirective());
        cfg.setSharedVariable("methodsD", (TemplateModel)new MethodsDirective());
        cfg.setSharedVariable("headerD", (TemplateModel)new HeaderDirective());
        cfg.setSharedVariable("unimplementedExceptionD", (TemplateModel)new UnimplementedExceptionDirective());
        return cfg;
    }
}

