/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.MockitoAnnotations;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.FtlFilePersister;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.GeneralInterfaceTemplate;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.Field;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.MethodDeclaration;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.util.FormattingUtil;

public class FtlFilePersisterTest {
    private final FtlFilePersister tested = new FtlFilePersister();

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testGeneralInterface() {
        String packageName = "pa.cka.ge";
        String name = "GeneralClassImpl";
        List<String> extendedInterfaces = Arrays.asList("List", "Set");
        ArrayList<MethodDeclaration> methods = new ArrayList<MethodDeclaration>();
        methods.add(new MethodDeclaration("String", "executeOperation", Collections.emptyList()));
        ArrayList mods = Lists.newArrayList();
        ArrayList mods2 = Lists.newArrayList((Object[])new String[]{"final"});
        methods.add(new MethodDeclaration("String", "executeOperation", Arrays.asList(new Field((List)mods, "int", "param1"), new Field((List)mods2, "long", "param2"))));
        GeneralInterfaceTemplate generalInterface = new GeneralInterfaceTemplate(null, packageName, name, extendedInterfaces, methods);
        Map abstractFtlFileStringMap = this.tested.serializeFtls(Arrays.asList(generalInterface));
        String content = FormattingUtil.cleanUpEmptyLinesAndIndent((String)abstractFtlFileStringMap.get(generalInterface));
        content = content.substring(content.indexOf("package"));
        String expected = "package pa.cka.ge;\n/**\n*\n*/\npublic interface GeneralClassImpl extends List, Set\n{\npublic String executeOperation();\npublic String executeOperation(int param1, final long param2);\n}\n";
        Assert.assertEquals((Object)expected, (Object)content);
    }
}

