/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.plugin;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.opendaylight.controller.config.yangjmxgenerator.ModuleMXBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.JavaAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.AbstractFactoryTemplate;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.TemplateFactory;
import org.opendaylight.yangtools.sal.binding.model.api.Type;

public class ModuleMXBeanEntryTemplatesTest {
    @Test
    public void test() {
        ModuleMXBeanEntry mbe = this.mockMbe("package");
        AbstractFactoryTemplate template = TemplateFactory.abstractFactoryTemplateFromMbe((ModuleMXBeanEntry)mbe);
        Assert.assertNotNull((Object)template);
    }

    private ModuleMXBeanEntry mockMbe(String packageName) {
        ModuleMXBeanEntry mbe = (ModuleMXBeanEntry)Mockito.mock(ModuleMXBeanEntry.class);
        HashMap a = Maps.newHashMap();
        JavaAttribute attr = this.mockJavaAttr();
        a.put("attr1", attr);
        ((ModuleMXBeanEntry)Mockito.doReturn((Object)a).when((Object)mbe)).getAttributes();
        ((ModuleMXBeanEntry)Mockito.doReturn((Object)packageName).when((Object)mbe)).getPackageName();
        ((ModuleMXBeanEntry)Mockito.doReturn(Collections.emptyMap()).when((Object)mbe)).getProvidedServices();
        ((ModuleMXBeanEntry)Mockito.doReturn((Object)"yang-module").when((Object)mbe)).getYangModuleName();
        ((ModuleMXBeanEntry)Mockito.doReturn((Object)"local").when((Object)mbe)).getYangModuleLocalname();
        ((ModuleMXBeanEntry)Mockito.doReturn((Object)"AbstractType").when((Object)mbe)).getAbstractFactoryName();
        ((ModuleMXBeanEntry)Mockito.doReturn((Object)"Module").when((Object)mbe)).getStubModuleName();
        ((ModuleMXBeanEntry)Mockito.doReturn((Object)"fullA").when((Object)mbe)).getFullyQualifiedName(Matchers.anyString());
        ((ModuleMXBeanEntry)Mockito.doReturn((Object)"uniq").when((Object)mbe)).getGloballyUniqueName();
        return mbe;
    }

    private JavaAttribute mockJavaAttr() {
        JavaAttribute attr = (JavaAttribute)Mockito.mock(JavaAttribute.class);
        Type typeA = (Type)Mockito.mock(Type.class);
        ((Type)Mockito.doReturn((Object)"package").when((Object)typeA)).getName();
        ((Type)Mockito.doReturn((Object)"type").when((Object)typeA)).getPackageName();
        ((Type)Mockito.doReturn((Object)"package.type").when((Object)typeA)).getFullyQualifiedName();
        ((JavaAttribute)Mockito.doReturn((Object)typeA).when((Object)attr)).getType();
        ((JavaAttribute)Mockito.doReturn((Object)"Type").when((Object)attr)).getUpperCaseCammelCase();
        ((JavaAttribute)Mockito.doReturn((Object)"new Default()").when((Object)attr)).getNullableDefault();
        return attr;
    }
}

