/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.clustering.it.provider;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.PoisonPill;
import akka.actor.Props;
import akka.dispatch.OnComplete;
import akka.pattern.Patterns;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.opendaylight.controller.cluster.ActorSystemProvider;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientLocalHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.DataStoreClient;
import org.opendaylight.controller.cluster.databroker.actors.dds.SimpleDataStoreClientActor;
import org.opendaylight.controller.cluster.datastore.DistributedDataStoreInterface;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.controller.cluster.datastore.utils.ClusterUtils;
import org.opendaylight.controller.cluster.raft.client.messages.Shutdown;
import org.opendaylight.controller.cluster.sharding.DistributedShardFactory;
import org.opendaylight.controller.clustering.it.provider.impl.FlappingSingletonService;
import org.opendaylight.controller.clustering.it.provider.impl.GetConstantService;
import org.opendaylight.controller.clustering.it.provider.impl.IdIntsDOMDataTreeLIstener;
import org.opendaylight.controller.clustering.it.provider.impl.IdIntsListener;
import org.opendaylight.controller.clustering.it.provider.impl.PrefixLeaderHandler;
import org.opendaylight.controller.clustering.it.provider.impl.PrefixShardHandler;
import org.opendaylight.controller.clustering.it.provider.impl.ProduceTransactionsHandler;
import org.opendaylight.controller.clustering.it.provider.impl.PublishNotificationsTask;
import org.opendaylight.controller.clustering.it.provider.impl.RoutedGetConstantService;
import org.opendaylight.controller.clustering.it.provider.impl.SingletonGetConstantService;
import org.opendaylight.controller.clustering.it.provider.impl.WriteTransactionsHandler;
import org.opendaylight.controller.clustering.it.provider.impl.YnlListener;
import org.opendaylight.controller.md.sal.binding.api.NotificationPublishService;
import org.opendaylight.controller.md.sal.binding.api.NotificationService;
import org.opendaylight.controller.md.sal.dom.api.DOMDataBroker;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadOnlyTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeChangeService;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcImplementationRegistration;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcProviderService;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.controller.sal.binding.api.RpcProviderRegistry;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeLoopException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeService;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.mdsal.singleton.common.api.ClusterSingletonServiceProvider;
import org.opendaylight.mdsal.singleton.common.api.ClusterSingletonServiceRegistration;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.AddShardReplicaInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.AddShardReplicaOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.BecomePrefixLeaderInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.BecomePrefixLeaderOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.CheckPublishNotificationsInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.CheckPublishNotificationsOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.CheckPublishNotificationsOutputBuilder;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.CreatePrefixShardInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.CreatePrefixShardOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.DeconfigureIdIntsShardInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.DeconfigureIdIntsShardOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.IsClientAbortedInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.IsClientAbortedOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.OdlMdsalLowlevelControlService;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.ProduceTransactionsInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.ProduceTransactionsOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RegisterBoundConstantInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RegisterBoundConstantOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RegisterBoundConstantOutputBuilder;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RegisterConstantInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RegisterConstantOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RegisterConstantOutputBuilder;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RegisterDefaultConstantInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RegisterDefaultConstantOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RegisterFlappingSingletonInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RegisterFlappingSingletonOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RegisterFlappingSingletonOutputBuilder;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RegisterSingletonConstantInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RegisterSingletonConstantOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RegisterSingletonConstantOutputBuilder;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RemovePrefixShardInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RemovePrefixShardOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RemoveShardReplicaInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RemoveShardReplicaOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.ShutdownPrefixShardReplicaInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.ShutdownPrefixShardReplicaOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.ShutdownPrefixShardReplicaOutputBuilder;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.ShutdownShardReplicaInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.ShutdownShardReplicaOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.ShutdownShardReplicaOutputBuilder;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.StartPublishNotificationsInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.StartPublishNotificationsOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.StartPublishNotificationsOutputBuilder;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.SubscribeDdtlInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.SubscribeDdtlOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.SubscribeDdtlOutputBuilder;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.SubscribeDtclInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.SubscribeDtclOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.SubscribeDtclOutputBuilder;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.SubscribeYnlInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.SubscribeYnlOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.SubscribeYnlOutputBuilder;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnregisterBoundConstantInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnregisterBoundConstantOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnregisterBoundConstantOutputBuilder;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnregisterConstantInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnregisterConstantOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnregisterConstantOutputBuilder;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnregisterDefaultConstantInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnregisterDefaultConstantOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnregisterFlappingSingletonInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnregisterFlappingSingletonOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnregisterFlappingSingletonOutputBuilder;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnregisterSingletonConstantInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnregisterSingletonConstantOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnregisterSingletonConstantOutputBuilder;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnsubscribeDdtlInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnsubscribeDdtlOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnsubscribeDdtlOutputBuilder;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnsubscribeDtclInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnsubscribeDtclOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnsubscribeDtclOutputBuilder;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnsubscribeYnlInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.UnsubscribeYnlOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.WriteTransactionsInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.WriteTransactionsOutput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.NotificationListener;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.Promise;
import scala.concurrent.duration.FiniteDuration;

public class MdsalLowLevelTestProvider
implements OdlMdsalLowlevelControlService {
    private static final Logger LOG = LoggerFactory.getLogger(MdsalLowLevelTestProvider.class);
    private static final org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType CONTROLLER_CONFIG = org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType.CONFIGURATION;
    private final RpcProviderRegistry rpcRegistry;
    private final BindingAwareBroker.RpcRegistration<OdlMdsalLowlevelControlService> registration;
    private final DistributedShardFactory distributedShardFactory;
    private final DistributedDataStoreInterface configDataStore;
    private final DOMDataTreeService domDataTreeService;
    private final BindingNormalizedNodeSerializer bindingNormalizedNodeSerializer;
    private final DOMDataBroker domDataBroker;
    private final NotificationPublishService notificationPublishService;
    private final NotificationService notificationService;
    private final DOMSchemaService schemaService;
    private final ClusterSingletonServiceProvider singletonService;
    private final DOMRpcProviderService domRpcService;
    private final PrefixLeaderHandler prefixLeaderHandler;
    private final PrefixShardHandler prefixShardHandler;
    private final DOMDataTreeChangeService domDataTreeChangeService;
    private final ActorSystem actorSystem;
    private final Map<InstanceIdentifier<?>, DOMRpcImplementationRegistration<RoutedGetConstantService>> routedRegistrations = new HashMap();
    private final Map<String, ListenerRegistration<YnlListener>> ynlRegistrations = new HashMap<String, ListenerRegistration<YnlListener>>();
    private DOMRpcImplementationRegistration<GetConstantService> globalGetConstantRegistration = null;
    private ClusterSingletonServiceRegistration getSingletonConstantRegistration;
    private FlappingSingletonService flappingSingletonService;
    private ListenerRegistration<DOMDataTreeChangeListener> dtclReg;
    private IdIntsListener idIntsListener;
    private final Map<String, PublishNotificationsTask> publishNotificationsTasks = new HashMap<String, PublishNotificationsTask>();
    private ListenerRegistration<IdIntsDOMDataTreeLIstener> ddtlReg;
    private IdIntsDOMDataTreeLIstener idIntsDdtl;

    public MdsalLowLevelTestProvider(RpcProviderRegistry rpcRegistry, DOMRpcProviderService domRpcService, ClusterSingletonServiceProvider singletonService, DOMSchemaService schemaService, BindingNormalizedNodeSerializer bindingNormalizedNodeSerializer, NotificationPublishService notificationPublishService, NotificationService notificationService, DOMDataBroker domDataBroker, DOMDataTreeService domDataTreeService, DistributedShardFactory distributedShardFactory, DistributedDataStoreInterface configDataStore, ActorSystemProvider actorSystemProvider) {
        this.rpcRegistry = rpcRegistry;
        this.domRpcService = domRpcService;
        this.singletonService = singletonService;
        this.schemaService = schemaService;
        this.bindingNormalizedNodeSerializer = bindingNormalizedNodeSerializer;
        this.notificationPublishService = notificationPublishService;
        this.notificationService = notificationService;
        this.domDataBroker = domDataBroker;
        this.domDataTreeService = domDataTreeService;
        this.distributedShardFactory = distributedShardFactory;
        this.configDataStore = configDataStore;
        this.actorSystem = actorSystemProvider.getActorSystem();
        this.prefixLeaderHandler = new PrefixLeaderHandler(domDataTreeService, bindingNormalizedNodeSerializer);
        this.domDataTreeChangeService = (DOMDataTreeChangeService)domDataBroker.getSupportedExtensions().get(DOMDataTreeChangeService.class);
        this.registration = rpcRegistry.addRpcImplementation(OdlMdsalLowlevelControlService.class, (RpcService)this);
        this.prefixShardHandler = new PrefixShardHandler(distributedShardFactory, domDataTreeService, bindingNormalizedNodeSerializer);
    }

    public ListenableFuture<RpcResult<UnregisterSingletonConstantOutput>> unregisterSingletonConstant(UnregisterSingletonConstantInput input) {
        LOG.info("In unregisterSingletonConstant");
        if (this.getSingletonConstantRegistration == null) {
            return RpcResultBuilder.failed().withError(RpcError.ErrorType.RPC, "data-missing", "No prior RPC was registered").buildFuture();
        }
        try {
            this.getSingletonConstantRegistration.close();
            this.getSingletonConstantRegistration = null;
            return RpcResultBuilder.success((Object)new UnregisterSingletonConstantOutputBuilder().build()).buildFuture();
        }
        catch (Exception e) {
            String msg = "Error closing the singleton constant service";
            LOG.error(msg, (Throwable)e);
            return RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, msg, (Throwable)e).buildFuture();
        }
    }

    public ListenableFuture<RpcResult<StartPublishNotificationsOutput>> startPublishNotifications(StartPublishNotificationsInput input) {
        LOG.info("In startPublishNotifications - input: {}", (Object)input);
        PublishNotificationsTask task = new PublishNotificationsTask(this.notificationPublishService, input.getId(), input.getSeconds().toJava(), input.getNotificationsPerSecond().toJava());
        this.publishNotificationsTasks.put(input.getId(), task);
        task.start();
        return RpcResultBuilder.success((Object)new StartPublishNotificationsOutputBuilder().build()).buildFuture();
    }

    public ListenableFuture<RpcResult<SubscribeDtclOutput>> subscribeDtcl(SubscribeDtclInput input) {
        LOG.info("In subscribeDtcl - input: {}", (Object)input);
        if (this.dtclReg != null) {
            return RpcResultBuilder.failed().withError(RpcError.ErrorType.RPC, "data-exists", "There is already a DataTreeChangeListener registered for id-ints").buildFuture();
        }
        this.idIntsListener = new IdIntsListener();
        this.dtclReg = this.domDataTreeChangeService.registerDataTreeChangeListener(new DOMDataTreeIdentifier(CONTROLLER_CONFIG, WriteTransactionsHandler.ID_INT_YID), (DOMDataTreeChangeListener)this.idIntsListener);
        return RpcResultBuilder.success((Object)new SubscribeDtclOutputBuilder().build()).buildFuture();
    }

    public ListenableFuture<RpcResult<WriteTransactionsOutput>> writeTransactions(WriteTransactionsInput input) {
        return WriteTransactionsHandler.start(this.domDataBroker, input);
    }

    public ListenableFuture<RpcResult<IsClientAbortedOutput>> isClientAborted(IsClientAbortedInput input) {
        return null;
    }

    public ListenableFuture<RpcResult<RemoveShardReplicaOutput>> removeShardReplica(RemoveShardReplicaInput input) {
        return null;
    }

    public ListenableFuture<RpcResult<SubscribeYnlOutput>> subscribeYnl(SubscribeYnlInput input) {
        LOG.info("In subscribeYnl - input: {}", (Object)input);
        if (this.ynlRegistrations.containsKey(input.getId())) {
            return RpcResultBuilder.failed().withError(RpcError.ErrorType.RPC, "data-exists", "There is already a listener registered for id: " + input.getId()).buildFuture();
        }
        this.ynlRegistrations.put(input.getId(), (ListenerRegistration<YnlListener>)this.notificationService.registerNotificationListener((NotificationListener)new YnlListener(input.getId())));
        return RpcResultBuilder.success((Object)new SubscribeYnlOutputBuilder().build()).buildFuture();
    }

    public ListenableFuture<RpcResult<RemovePrefixShardOutput>> removePrefixShard(RemovePrefixShardInput input) {
        LOG.info("In removePrefixShard - input: {}", (Object)input);
        return this.prefixShardHandler.onRemovePrefixShard(input);
    }

    public ListenableFuture<RpcResult<BecomePrefixLeaderOutput>> becomePrefixLeader(BecomePrefixLeaderInput input) {
        LOG.info("n becomePrefixLeader - input: {}", (Object)input);
        return this.prefixLeaderHandler.makeLeaderLocal(input);
    }

    public ListenableFuture<RpcResult<UnregisterBoundConstantOutput>> unregisterBoundConstant(UnregisterBoundConstantInput input) {
        LOG.info("In unregisterBoundConstant - {}", (Object)input);
        DOMRpcImplementationRegistration<RoutedGetConstantService> rpcRegistration = this.routedRegistrations.remove(input.getContext());
        if (rpcRegistration == null) {
            return RpcResultBuilder.failed().withError(RpcError.ErrorType.RPC, "data-missing", "No prior RPC was registered for " + input.getContext()).buildFuture();
        }
        rpcRegistration.close();
        return RpcResultBuilder.success((Object)new UnregisterBoundConstantOutputBuilder().build()).buildFuture();
    }

    public ListenableFuture<RpcResult<RegisterSingletonConstantOutput>> registerSingletonConstant(RegisterSingletonConstantInput input) {
        LOG.info("In registerSingletonConstant - input: {}", (Object)input);
        if (input.getConstant() == null) {
            return RpcResultBuilder.failed().withError(RpcError.ErrorType.RPC, "invalid-value", "Constant value is null").buildFuture();
        }
        this.getSingletonConstantRegistration = SingletonGetConstantService.registerNew(this.singletonService, this.domRpcService, input.getConstant());
        return RpcResultBuilder.success((Object)new RegisterSingletonConstantOutputBuilder().build()).buildFuture();
    }

    public ListenableFuture<RpcResult<RegisterDefaultConstantOutput>> registerDefaultConstant(RegisterDefaultConstantInput input) {
        return null;
    }

    public ListenableFuture<RpcResult<UnregisterConstantOutput>> unregisterConstant(UnregisterConstantInput input) {
        LOG.info("In unregisterConstant");
        if (this.globalGetConstantRegistration == null) {
            return RpcResultBuilder.failed().withError(RpcError.ErrorType.RPC, "data-missing", "No prior RPC was registered").buildFuture();
        }
        this.globalGetConstantRegistration.close();
        this.globalGetConstantRegistration = null;
        return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)new UnregisterConstantOutputBuilder().build()).build());
    }

    public ListenableFuture<RpcResult<UnregisterFlappingSingletonOutput>> unregisterFlappingSingleton(UnregisterFlappingSingletonInput input) {
        LOG.info("In unregisterFlappingSingleton");
        if (this.flappingSingletonService == null) {
            return RpcResultBuilder.failed().withError(RpcError.ErrorType.RPC, "data-missing", "No prior RPC was registered").buildFuture();
        }
        long flapCount = this.flappingSingletonService.setInactive();
        this.flappingSingletonService = null;
        return RpcResultBuilder.success((Object)new UnregisterFlappingSingletonOutputBuilder().setFlapCount(Long.valueOf(flapCount)).build()).buildFuture();
    }

    public ListenableFuture<RpcResult<AddShardReplicaOutput>> addShardReplica(AddShardReplicaInput input) {
        return null;
    }

    public ListenableFuture<RpcResult<SubscribeDdtlOutput>> subscribeDdtl(SubscribeDdtlInput input) {
        LOG.info("In subscribeDdtl");
        if (this.ddtlReg != null) {
            return RpcResultBuilder.failed().withError(RpcError.ErrorType.RPC, "data-exists", "There is already a listener registered for id-ints").buildFuture();
        }
        this.idIntsDdtl = new IdIntsDOMDataTreeLIstener();
        try {
            this.ddtlReg = this.domDataTreeService.registerListener((DOMDataTreeListener)this.idIntsDdtl, Collections.singleton(new org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, ProduceTransactionsHandler.ID_INT_YID)), true, Collections.emptyList());
        }
        catch (DOMDataTreeLoopException e) {
            LOG.error("Failed to register DOMDataTreeListener", (Throwable)e);
            return RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "Failed to register DOMDataTreeListener", (Throwable)e).buildFuture();
        }
        return RpcResultBuilder.success((Object)new SubscribeDdtlOutputBuilder().build()).buildFuture();
    }

    public ListenableFuture<RpcResult<RegisterBoundConstantOutput>> registerBoundConstant(RegisterBoundConstantInput input) {
        LOG.info("In registerBoundConstant - input: {}", (Object)input);
        if (input.getContext() == null) {
            return RpcResultBuilder.failed().withError(RpcError.ErrorType.RPC, "invalid-value", "Context value is null").buildFuture();
        }
        if (input.getConstant() == null) {
            return RpcResultBuilder.failed().withError(RpcError.ErrorType.RPC, "invalid-value", "Constant value is null").buildFuture();
        }
        if (this.routedRegistrations.containsKey(input.getContext())) {
            return RpcResultBuilder.failed().withError(RpcError.ErrorType.RPC, "data-exists", "There is already an rpc registered for context: " + input.getContext()).buildFuture();
        }
        DOMRpcImplementationRegistration<RoutedGetConstantService> rpcRegistration = RoutedGetConstantService.registerNew(this.bindingNormalizedNodeSerializer, this.domRpcService, input.getConstant(), input.getContext());
        this.routedRegistrations.put(input.getContext(), rpcRegistration);
        return RpcResultBuilder.success((Object)new RegisterBoundConstantOutputBuilder().build()).buildFuture();
    }

    public ListenableFuture<RpcResult<RegisterFlappingSingletonOutput>> registerFlappingSingleton(RegisterFlappingSingletonInput input) {
        LOG.info("In registerFlappingSingleton");
        if (this.flappingSingletonService != null) {
            return RpcResultBuilder.failed().withError(RpcError.ErrorType.RPC, "data-exists", "There is already an rpc registered").buildFuture();
        }
        this.flappingSingletonService = new FlappingSingletonService(this.singletonService);
        return RpcResultBuilder.success((Object)new RegisterFlappingSingletonOutputBuilder().build()).buildFuture();
    }

    public ListenableFuture<RpcResult<UnsubscribeDtclOutput>> unsubscribeDtcl(UnsubscribeDtclInput input) {
        LOG.info("In unsubscribeDtcl");
        if (this.idIntsListener == null || this.dtclReg == null) {
            return RpcResultBuilder.failed().withError(RpcError.ErrorType.RPC, "data-missing", "No prior listener was registered").buildFuture();
        }
        long timeout = 120L;
        try {
            this.idIntsListener.tryFinishProcessing().get(timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOG.error("Unable to finish notification processing", (Throwable)e);
            return RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "Unable to finish notification processing in " + timeout + " seconds", (Throwable)e).buildFuture();
        }
        this.dtclReg.close();
        this.dtclReg = null;
        if (!this.idIntsListener.hasTriggered()) {
            return RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "operation-failed", "id-ints listener has not received any notifications.").buildFuture();
        }
        DOMDataReadOnlyTransaction rTx = this.domDataBroker.newReadOnlyTransaction();
        try {
            com.google.common.base.Optional readResult = (com.google.common.base.Optional)rTx.read(CONTROLLER_CONFIG, WriteTransactionsHandler.ID_INT_YID).get();
            if (!readResult.isPresent()) {
                return RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "data-missing", "No data read from id-ints list").buildFuture();
            }
            boolean nodesEqual = this.idIntsListener.checkEqual((NormalizedNode)readResult.get());
            if (!nodesEqual) {
                LOG.error("Final read of id-int does not match IdIntsListener's copy. {}", (Object)this.idIntsListener.diffWithLocalCopy((NormalizedNode)readResult.get()));
            }
            return RpcResultBuilder.success((Builder)new UnsubscribeDtclOutputBuilder().setCopyMatches(Boolean.valueOf(nodesEqual))).buildFuture();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Final read of id-ints failed", (Throwable)e);
            return RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "Final read of id-ints failed", (Throwable)e).buildFuture();
        }
    }

    public ListenableFuture<RpcResult<CreatePrefixShardOutput>> createPrefixShard(CreatePrefixShardInput input) {
        LOG.info("In createPrefixShard - input: {}", (Object)input);
        return this.prefixShardHandler.onCreatePrefixShard(input);
    }

    public ListenableFuture<RpcResult<DeconfigureIdIntsShardOutput>> deconfigureIdIntsShard(DeconfigureIdIntsShardInput input) {
        return null;
    }

    public ListenableFuture<RpcResult<UnsubscribeYnlOutput>> unsubscribeYnl(UnsubscribeYnlInput input) {
        LOG.info("In unsubscribeYnl - input: {}", (Object)input);
        if (!this.ynlRegistrations.containsKey(input.getId())) {
            return RpcResultBuilder.failed().withError(RpcError.ErrorType.RPC, "data-missing", "No prior listener was registered for " + input.getId()).buildFuture();
        }
        ListenerRegistration<YnlListener> reg = this.ynlRegistrations.remove(input.getId());
        UnsubscribeYnlOutput output = ((YnlListener)reg.getInstance()).getOutput();
        reg.close();
        return RpcResultBuilder.success().withResult((Object)output).buildFuture();
    }

    public ListenableFuture<RpcResult<CheckPublishNotificationsOutput>> checkPublishNotifications(CheckPublishNotificationsInput input) {
        LOG.info("In checkPublishNotifications - input: {}", (Object)input);
        PublishNotificationsTask task = this.publishNotificationsTasks.get(input.getId());
        if (task == null) {
            return Futures.immediateFuture((Object)RpcResultBuilder.success((Builder)new CheckPublishNotificationsOutputBuilder().setActive(Boolean.valueOf(false))).build());
        }
        CheckPublishNotificationsOutputBuilder checkPublishNotificationsOutputBuilder = new CheckPublishNotificationsOutputBuilder().setActive(Boolean.valueOf(!task.isFinished()));
        if (task.getLastError() != null) {
            LOG.error("Last error for {}", (Object)task, (Object)task.getLastError());
            checkPublishNotificationsOutputBuilder.setLastError(task.getLastError().toString());
        }
        CheckPublishNotificationsOutput output = checkPublishNotificationsOutputBuilder.setPublishCount(Long.valueOf(task.getCurrentNotif())).build();
        return RpcResultBuilder.success((Object)output).buildFuture();
    }

    public ListenableFuture<RpcResult<ProduceTransactionsOutput>> produceTransactions(ProduceTransactionsInput input) {
        LOG.info("In produceTransactions - input: {}", (Object)input);
        return ProduceTransactionsHandler.start(this.domDataTreeService, input);
    }

    public ListenableFuture<RpcResult<ShutdownShardReplicaOutput>> shutdownShardReplica(ShutdownShardReplicaInput input) {
        LOG.info("In shutdownShardReplica - input: {}", (Object)input);
        String shardName = input.getShardName();
        if (Strings.isNullOrEmpty((String)shardName)) {
            return RpcResultBuilder.failed().withError(RpcError.ErrorType.RPC, "bad-element", shardName + "is not a valid shard name").buildFuture();
        }
        return this.shutdownShardGracefully(shardName, new ShutdownShardReplicaOutputBuilder().build());
    }

    public ListenableFuture<RpcResult<ShutdownPrefixShardReplicaOutput>> shutdownPrefixShardReplica(ShutdownPrefixShardReplicaInput input) {
        LOG.info("shutdownPrefixShardReplica - input: {}", (Object)input);
        InstanceIdentifier shardPrefix = input.getPrefix();
        if (shardPrefix == null) {
            return RpcResultBuilder.failed().withError(RpcError.ErrorType.RPC, "bad-element", "A valid shard prefix must be specified").buildFuture();
        }
        YangInstanceIdentifier shardPath = this.bindingNormalizedNodeSerializer.toYangInstanceIdentifier(shardPrefix);
        String cleanPrefixShardName = ClusterUtils.getCleanShardName((YangInstanceIdentifier)shardPath);
        return this.shutdownShardGracefully(cleanPrefixShardName, new ShutdownPrefixShardReplicaOutputBuilder().build());
    }

    private <T> SettableFuture<RpcResult<T>> shutdownShardGracefully(String shardName, final T success) {
        final SettableFuture rpcResult = SettableFuture.create();
        ActorUtils context = this.configDataStore.getActorUtils();
        long timeoutInMS = Math.max(context.getDatastoreContext().getShardRaftConfig().getElectionTimeOutInterval().$times(3L).toMillis(), 10000L);
        final FiniteDuration duration = FiniteDuration.apply((long)timeoutInMS, (TimeUnit)TimeUnit.MILLISECONDS);
        final Promise shutdownShardAsk = akka.dispatch.Futures.promise();
        context.findLocalShardAsync(shardName).onComplete((Function1)new OnComplete<ActorRef>(){

            public void onComplete(Throwable throwable, ActorRef actorRef) {
                if (throwable != null) {
                    shutdownShardAsk.failure(throwable);
                } else {
                    shutdownShardAsk.completeWith(Patterns.gracefulStop((ActorRef)actorRef, (FiniteDuration)duration, (Object)Shutdown.INSTANCE));
                }
            }
        }, context.getClientDispatcher());
        shutdownShardAsk.future().onComplete((Function1)new OnComplete<Boolean>(){

            public void onComplete(Throwable throwable, Boolean gracefulStopResult) {
                if (throwable != null) {
                    RpcResult failedResult = RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "Failed to gracefully shutdown shard", throwable).build();
                    rpcResult.set((Object)failedResult);
                } else {
                    rpcResult.set((Object)RpcResultBuilder.success((Object)success).build());
                }
            }
        }, context.getClientDispatcher());
        return rpcResult;
    }

    public ListenableFuture<RpcResult<RegisterConstantOutput>> registerConstant(RegisterConstantInput input) {
        LOG.info("In registerConstant - input: {}", (Object)input);
        if (input.getConstant() == null) {
            return RpcResultBuilder.failed().withError(RpcError.ErrorType.RPC, "invalid-value", "Constant value is null").buildFuture();
        }
        if (this.globalGetConstantRegistration != null) {
            return RpcResultBuilder.failed().withError(RpcError.ErrorType.RPC, "data-exists", "There is already an rpc registered").buildFuture();
        }
        this.globalGetConstantRegistration = GetConstantService.registerNew(this.domRpcService, input.getConstant());
        return RpcResultBuilder.success((Object)new RegisterConstantOutputBuilder().build()).buildFuture();
    }

    public ListenableFuture<RpcResult<UnregisterDefaultConstantOutput>> unregisterDefaultConstant(UnregisterDefaultConstantInput input) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<RpcResult<UnsubscribeDdtlOutput>> unsubscribeDdtl(UnsubscribeDdtlInput input) {
        DataStoreClient distributedDataStoreClient;
        LOG.info("In unsubscribeDdtl");
        if (this.idIntsDdtl == null || this.ddtlReg == null) {
            return RpcResultBuilder.failed().withError(RpcError.ErrorType.RPC, "data-missing", "No prior listener was registered").buildFuture();
        }
        long timeout = 120L;
        try {
            this.idIntsDdtl.tryFinishProcessing().get(timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOG.error("Unable to finish notification processing", (Throwable)e);
            return RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "Unable to finish notification processing in " + timeout + " seconds", (Throwable)e).buildFuture();
        }
        this.ddtlReg.close();
        this.ddtlReg = null;
        if (!this.idIntsDdtl.hasTriggered()) {
            return RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "No notification received.", "id-ints listener has not received any notifications").buildFuture();
        }
        String shardName = ClusterUtils.getCleanShardName((YangInstanceIdentifier)ProduceTransactionsHandler.ID_INTS_YID);
        LOG.debug("Creating distributed datastore client for shard {}", (Object)shardName);
        ActorUtils actorUtils = this.configDataStore.getActorUtils();
        Props distributedDataStoreClientProps = SimpleDataStoreClientActor.props((MemberName)actorUtils.getCurrentMemberName(), (String)("Shard-" + shardName), (ActorUtils)actorUtils, (String)shardName);
        ActorRef clientActor = this.actorSystem.actorOf(distributedDataStoreClientProps);
        try {
            distributedDataStoreClient = SimpleDataStoreClientActor.getDistributedDataStoreClient((ActorRef)clientActor, (long)30L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (RuntimeException e) {
            LOG.error("Failed to get actor for {}", (Object)distributedDataStoreClientProps, (Object)e);
            clientActor.tell((Object)PoisonPill.getInstance(), ActorRef.noSender());
            return RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "Unable to create DataStoreClient for read", (Throwable)e).buildFuture();
        }
        ClientLocalHistory localHistory = distributedDataStoreClient.createLocalHistory();
        ClientTransaction tx = localHistory.createTransaction();
        FluentFuture read = tx.read(YangInstanceIdentifier.of((QName)ProduceTransactionsHandler.ID_INT));
        tx.abort();
        localHistory.close();
        try {
            Optional optional = (Optional)read.get();
            if (!optional.isPresent()) {
                FluentFuture fluentFuture = RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "data-missing", "Final read from id-ints is empty").buildFuture();
                return fluentFuture;
            }
            FluentFuture fluentFuture = RpcResultBuilder.success((Builder)new UnsubscribeDdtlOutputBuilder().setCopyMatches(Boolean.valueOf(this.idIntsDdtl.checkEqual((NormalizedNode)optional.get())))).buildFuture();
            return fluentFuture;
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Unable to read data to verify ddtl data", (Throwable)e);
            FluentFuture fluentFuture = RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "Final read from id-ints failed", (Throwable)e).buildFuture();
            return fluentFuture;
        }
        finally {
            distributedDataStoreClient.close();
            clientActor.tell((Object)PoisonPill.getInstance(), ActorRef.noSender());
        }
    }
}

