/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.common.rev131028.rpc.router.routing.tables;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.common.rev131028.RpcRoutingTable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.common.rev131028.rpc.router.routing.tables.RoutingTable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.common.rev131028.rpc.routing.table.Routes;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RoutingTableBuilder
implements Builder<RoutingTable> {
    private List<Routes> _routes;
    private String _routingContext;
    Map<Class<? extends Augmentation<RoutingTable>>, Augmentation<RoutingTable>> augmentation = Collections.emptyMap();

    public RoutingTableBuilder() {
    }

    public RoutingTableBuilder(RpcRoutingTable arg) {
        this._routingContext = arg.getRoutingContext();
        this._routes = arg.getRoutes();
    }

    public RoutingTableBuilder(RoutingTable base) {
        AugmentationHolder casted;
        this._routes = base.getRoutes();
        this._routingContext = base.getRoutingContext();
        if (base instanceof RoutingTableImpl) {
            RoutingTableImpl impl = (RoutingTableImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<RoutingTable>>, Augmentation<RoutingTable>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RoutingTable>>, Augmentation<RoutingTable>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof RpcRoutingTable) {
            this._routingContext = ((RpcRoutingTable)arg).getRoutingContext();
            this._routes = ((RpcRoutingTable)arg).getRoutes();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.common.rev131028.RpcRoutingTable] \nbut was: " + arg);
        }
    }

    public List<Routes> getRoutes() {
        return this._routes;
    }

    public String getRoutingContext() {
        return this._routingContext;
    }

    public <E extends Augmentation<RoutingTable>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public RoutingTableBuilder setRoutes(List<Routes> value) {
        this._routes = value;
        return this;
    }

    public RoutingTableBuilder setRoutingContext(String value) {
        this._routingContext = value;
        return this;
    }

    public RoutingTableBuilder addAugmentation(Class<? extends Augmentation<RoutingTable>> augmentationType, Augmentation<RoutingTable> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RoutingTable>>, Augmentation<RoutingTable>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public RoutingTableBuilder removeAugmentation(Class<? extends Augmentation<RoutingTable>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public RoutingTable build() {
        return new RoutingTableImpl(this);
    }

    private static final class RoutingTableImpl
    implements RoutingTable {
        private final List<Routes> _routes;
        private final String _routingContext;
        private Map<Class<? extends Augmentation<RoutingTable>>, Augmentation<RoutingTable>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<RoutingTable> getImplementedInterface() {
            return RoutingTable.class;
        }

        private RoutingTableImpl(RoutingTableBuilder base) {
            this._routes = base.getRoutes();
            this._routingContext = base.getRoutingContext();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<RoutingTable>>, Augmentation<RoutingTable>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<RoutingTable>>, Augmentation<RoutingTable>>(base.augmentation);
                }
            }
        }

        @Override
        public List<Routes> getRoutes() {
            return this._routes;
        }

        @Override
        public String getRoutingContext() {
            return this._routingContext;
        }

        public <E extends Augmentation<RoutingTable>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._routes);
            result = 31 * result + Objects.hashCode(this._routingContext);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!RoutingTable.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            RoutingTable other = (RoutingTable)obj;
            if (!Objects.equals(this._routes, other.getRoutes())) {
                return false;
            }
            if (!Objects.equals(this._routingContext, other.getRoutingContext())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                RoutingTableImpl otherImpl = (RoutingTableImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<RoutingTable>>, Augmentation<RoutingTable>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "RoutingTable [";
            StringBuilder builder = new StringBuilder(name);
            if (this._routes != null) {
                builder.append("_routes=");
                builder.append(this._routes);
                builder.append(", ");
            }
            if (this._routingContext != null) {
                builder.append("_routingContext=");
                builder.append(this._routingContext);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

