/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.common.rev131028.data.state;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.common.rev131028.data.state.Transactions;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TransactionsBuilder
implements Builder<Transactions> {
    private Long _created;
    private Long _failed;
    private Long _submitted;
    private Long _successful;
    Map<Class<? extends Augmentation<Transactions>>, Augmentation<Transactions>> augmentation = Collections.emptyMap();

    public TransactionsBuilder() {
    }

    public TransactionsBuilder(Transactions base) {
        AugmentationHolder casted;
        this._created = base.getCreated();
        this._failed = base.getFailed();
        this._submitted = base.getSubmitted();
        this._successful = base.getSuccessful();
        if (base instanceof TransactionsImpl) {
            TransactionsImpl impl = (TransactionsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Transactions>>, Augmentation<Transactions>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Transactions>>, Augmentation<Transactions>>(casted.augmentations());
        }
    }

    public Long getCreated() {
        return this._created;
    }

    public Long getFailed() {
        return this._failed;
    }

    public Long getSubmitted() {
        return this._submitted;
    }

    public Long getSuccessful() {
        return this._successful;
    }

    public <E extends Augmentation<Transactions>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkCreatedRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public TransactionsBuilder setCreated(Long value) {
        if (value != null) {
            TransactionsBuilder.checkCreatedRange(value);
        }
        this._created = value;
        return this;
    }

    private static void checkFailedRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public TransactionsBuilder setFailed(Long value) {
        if (value != null) {
            TransactionsBuilder.checkFailedRange(value);
        }
        this._failed = value;
        return this;
    }

    private static void checkSubmittedRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public TransactionsBuilder setSubmitted(Long value) {
        if (value != null) {
            TransactionsBuilder.checkSubmittedRange(value);
        }
        this._submitted = value;
        return this;
    }

    private static void checkSuccessfulRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public TransactionsBuilder setSuccessful(Long value) {
        if (value != null) {
            TransactionsBuilder.checkSuccessfulRange(value);
        }
        this._successful = value;
        return this;
    }

    public TransactionsBuilder addAugmentation(Class<? extends Augmentation<Transactions>> augmentationType, Augmentation<Transactions> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Transactions>>, Augmentation<Transactions>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public TransactionsBuilder removeAugmentation(Class<? extends Augmentation<Transactions>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Transactions build() {
        return new TransactionsImpl(this);
    }

    private static final class TransactionsImpl
    implements Transactions {
        private final Long _created;
        private final Long _failed;
        private final Long _submitted;
        private final Long _successful;
        private Map<Class<? extends Augmentation<Transactions>>, Augmentation<Transactions>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Transactions> getImplementedInterface() {
            return Transactions.class;
        }

        private TransactionsImpl(TransactionsBuilder base) {
            this._created = base.getCreated();
            this._failed = base.getFailed();
            this._submitted = base.getSubmitted();
            this._successful = base.getSuccessful();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Transactions>>, Augmentation<Transactions>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Transactions>>, Augmentation<Transactions>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getCreated() {
            return this._created;
        }

        @Override
        public Long getFailed() {
            return this._failed;
        }

        @Override
        public Long getSubmitted() {
            return this._submitted;
        }

        @Override
        public Long getSuccessful() {
            return this._successful;
        }

        public <E extends Augmentation<Transactions>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._created);
            result = 31 * result + Objects.hashCode(this._failed);
            result = 31 * result + Objects.hashCode(this._submitted);
            result = 31 * result + Objects.hashCode(this._successful);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Transactions.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Transactions other = (Transactions)obj;
            if (!Objects.equals(this._created, other.getCreated())) {
                return false;
            }
            if (!Objects.equals(this._failed, other.getFailed())) {
                return false;
            }
            if (!Objects.equals(this._submitted, other.getSubmitted())) {
                return false;
            }
            if (!Objects.equals(this._successful, other.getSuccessful())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TransactionsImpl otherImpl = (TransactionsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Transactions>>, Augmentation<Transactions>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Transactions [";
            StringBuilder builder = new StringBuilder(name);
            if (this._created != null) {
                builder.append("_created=");
                builder.append(this._created);
                builder.append(", ");
            }
            if (this._failed != null) {
                builder.append("_failed=");
                builder.append(this._failed);
                builder.append(", ");
            }
            if (this._submitted != null) {
                builder.append("_submitted=");
                builder.append(this._submitted);
                builder.append(", ");
            }
            if (this._successful != null) {
                builder.append("_successful=");
                builder.append(this._successful);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

