/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.common.impl;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;
import org.opendaylight.yangtools.concepts.ListenerRegistration;

public class ListenerRegistry<T extends EventListener> {
    final Set<ListenerRegistration<T>> listeners = new HashSet<ListenerRegistration<T>>();
    final Set<ListenerRegistration<T>> unmodifiableView = Collections.unmodifiableSet(this.listeners);

    public Iterable<ListenerRegistration<T>> getListeners() {
        return this.unmodifiableView;
    }

    public ListenerRegistration<T> register(T listener) {
        Preconditions.checkNotNull(listener, (Object)"Listener should not be null.");
        ListenerRegistrationImpl ret = new ListenerRegistrationImpl(this, listener);
        this.listeners.add(ret);
        return ret;
    }

    private void remove(ListenerRegistrationImpl registration) {
        this.listeners.remove((Object)registration);
    }

    private static class ListenerRegistrationImpl<P extends EventListener>
    extends AbstractObjectRegistration<P>
    implements ListenerRegistration<P> {
        final /* synthetic */ ListenerRegistry this$0;

        public ListenerRegistrationImpl(P instance) {
            this.this$0 = var1_1;
            super(instance);
        }

        protected void removeRegistration() {
            this.this$0.remove(this);
        }
    }
}

