/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.modules.module.configuration;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.DomBrokerConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.dom.broker.config.ConfigDataStore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.dom.broker.config.OperationalDataStore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.dom.broker.config.SchemaService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.modules.module.configuration.DomInmemoryDataBroker;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class DomInmemoryDataBrokerBuilder
implements Builder<DomInmemoryDataBroker> {
    private ConfigDataStore _configDataStore;
    private Integer _maxDataBrokerCommitQueueSize;
    private Integer _maxDataBrokerFutureCallbackPoolSize;
    private Integer _maxDataBrokerFutureCallbackQueueSize;
    private OperationalDataStore _operationalDataStore;
    private SchemaService _schemaService;
    Map<Class<? extends Augmentation<DomInmemoryDataBroker>>, Augmentation<DomInmemoryDataBroker>> augmentation = Collections.emptyMap();

    public DomInmemoryDataBrokerBuilder() {
    }

    public DomInmemoryDataBrokerBuilder(DomBrokerConfig arg) {
        this._schemaService = arg.getSchemaService();
        this._configDataStore = arg.getConfigDataStore();
        this._operationalDataStore = arg.getOperationalDataStore();
        this._maxDataBrokerFutureCallbackQueueSize = arg.getMaxDataBrokerFutureCallbackQueueSize();
        this._maxDataBrokerFutureCallbackPoolSize = arg.getMaxDataBrokerFutureCallbackPoolSize();
        this._maxDataBrokerCommitQueueSize = arg.getMaxDataBrokerCommitQueueSize();
    }

    public DomInmemoryDataBrokerBuilder(DomInmemoryDataBroker base) {
        AugmentationHolder casted;
        this._configDataStore = base.getConfigDataStore();
        this._maxDataBrokerCommitQueueSize = base.getMaxDataBrokerCommitQueueSize();
        this._maxDataBrokerFutureCallbackPoolSize = base.getMaxDataBrokerFutureCallbackPoolSize();
        this._maxDataBrokerFutureCallbackQueueSize = base.getMaxDataBrokerFutureCallbackQueueSize();
        this._operationalDataStore = base.getOperationalDataStore();
        this._schemaService = base.getSchemaService();
        if (base instanceof DomInmemoryDataBrokerImpl) {
            DomInmemoryDataBrokerImpl impl = (DomInmemoryDataBrokerImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<DomInmemoryDataBroker>>, Augmentation<DomInmemoryDataBroker>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<DomInmemoryDataBroker>>, Augmentation<DomInmemoryDataBroker>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof DomBrokerConfig) {
            this._schemaService = ((DomBrokerConfig)arg).getSchemaService();
            this._configDataStore = ((DomBrokerConfig)arg).getConfigDataStore();
            this._operationalDataStore = ((DomBrokerConfig)arg).getOperationalDataStore();
            this._maxDataBrokerFutureCallbackQueueSize = ((DomBrokerConfig)arg).getMaxDataBrokerFutureCallbackQueueSize();
            this._maxDataBrokerFutureCallbackPoolSize = ((DomBrokerConfig)arg).getMaxDataBrokerFutureCallbackPoolSize();
            this._maxDataBrokerCommitQueueSize = ((DomBrokerConfig)arg).getMaxDataBrokerCommitQueueSize();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.DomBrokerConfig] \nbut was: " + arg);
        }
    }

    public ConfigDataStore getConfigDataStore() {
        return this._configDataStore;
    }

    public Integer getMaxDataBrokerCommitQueueSize() {
        return this._maxDataBrokerCommitQueueSize;
    }

    public Integer getMaxDataBrokerFutureCallbackPoolSize() {
        return this._maxDataBrokerFutureCallbackPoolSize;
    }

    public Integer getMaxDataBrokerFutureCallbackQueueSize() {
        return this._maxDataBrokerFutureCallbackQueueSize;
    }

    public OperationalDataStore getOperationalDataStore() {
        return this._operationalDataStore;
    }

    public SchemaService getSchemaService() {
        return this._schemaService;
    }

    public <E extends Augmentation<DomInmemoryDataBroker>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public DomInmemoryDataBrokerBuilder setConfigDataStore(ConfigDataStore value) {
        this._configDataStore = value;
        return this;
    }

    private static void checkMaxDataBrokerCommitQueueSizeRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public DomInmemoryDataBrokerBuilder setMaxDataBrokerCommitQueueSize(Integer value) {
        if (value != null) {
            DomInmemoryDataBrokerBuilder.checkMaxDataBrokerCommitQueueSizeRange(value);
        }
        this._maxDataBrokerCommitQueueSize = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _maxDataBrokerCommitQueueSize_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    private static void checkMaxDataBrokerFutureCallbackPoolSizeRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public DomInmemoryDataBrokerBuilder setMaxDataBrokerFutureCallbackPoolSize(Integer value) {
        if (value != null) {
            DomInmemoryDataBrokerBuilder.checkMaxDataBrokerFutureCallbackPoolSizeRange(value);
        }
        this._maxDataBrokerFutureCallbackPoolSize = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _maxDataBrokerFutureCallbackPoolSize_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    private static void checkMaxDataBrokerFutureCallbackQueueSizeRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public DomInmemoryDataBrokerBuilder setMaxDataBrokerFutureCallbackQueueSize(Integer value) {
        if (value != null) {
            DomInmemoryDataBrokerBuilder.checkMaxDataBrokerFutureCallbackQueueSizeRange(value);
        }
        this._maxDataBrokerFutureCallbackQueueSize = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _maxDataBrokerFutureCallbackQueueSize_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    public DomInmemoryDataBrokerBuilder setOperationalDataStore(OperationalDataStore value) {
        this._operationalDataStore = value;
        return this;
    }

    public DomInmemoryDataBrokerBuilder setSchemaService(SchemaService value) {
        this._schemaService = value;
        return this;
    }

    public DomInmemoryDataBrokerBuilder addAugmentation(Class<? extends Augmentation<DomInmemoryDataBroker>> augmentationType, Augmentation<DomInmemoryDataBroker> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<DomInmemoryDataBroker>>, Augmentation<DomInmemoryDataBroker>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public DomInmemoryDataBrokerBuilder removeAugmentation(Class<? extends Augmentation<DomInmemoryDataBroker>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public DomInmemoryDataBroker build() {
        return new DomInmemoryDataBrokerImpl(this);
    }

    private static final class DomInmemoryDataBrokerImpl
    implements DomInmemoryDataBroker {
        private final ConfigDataStore _configDataStore;
        private final Integer _maxDataBrokerCommitQueueSize;
        private final Integer _maxDataBrokerFutureCallbackPoolSize;
        private final Integer _maxDataBrokerFutureCallbackQueueSize;
        private final OperationalDataStore _operationalDataStore;
        private final SchemaService _schemaService;
        private Map<Class<? extends Augmentation<DomInmemoryDataBroker>>, Augmentation<DomInmemoryDataBroker>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<DomInmemoryDataBroker> getImplementedInterface() {
            return DomInmemoryDataBroker.class;
        }

        private DomInmemoryDataBrokerImpl(DomInmemoryDataBrokerBuilder base) {
            this._configDataStore = base.getConfigDataStore();
            this._maxDataBrokerCommitQueueSize = base.getMaxDataBrokerCommitQueueSize();
            this._maxDataBrokerFutureCallbackPoolSize = base.getMaxDataBrokerFutureCallbackPoolSize();
            this._maxDataBrokerFutureCallbackQueueSize = base.getMaxDataBrokerFutureCallbackQueueSize();
            this._operationalDataStore = base.getOperationalDataStore();
            this._schemaService = base.getSchemaService();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<DomInmemoryDataBroker>>, Augmentation<DomInmemoryDataBroker>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<DomInmemoryDataBroker>>, Augmentation<DomInmemoryDataBroker>>(base.augmentation);
                }
            }
        }

        @Override
        public ConfigDataStore getConfigDataStore() {
            return this._configDataStore;
        }

        @Override
        public Integer getMaxDataBrokerCommitQueueSize() {
            return this._maxDataBrokerCommitQueueSize;
        }

        @Override
        public Integer getMaxDataBrokerFutureCallbackPoolSize() {
            return this._maxDataBrokerFutureCallbackPoolSize;
        }

        @Override
        public Integer getMaxDataBrokerFutureCallbackQueueSize() {
            return this._maxDataBrokerFutureCallbackQueueSize;
        }

        @Override
        public OperationalDataStore getOperationalDataStore() {
            return this._operationalDataStore;
        }

        @Override
        public SchemaService getSchemaService() {
            return this._schemaService;
        }

        public <E extends Augmentation<DomInmemoryDataBroker>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._configDataStore == null ? 0 : this._configDataStore.hashCode());
            result = 31 * result + (this._maxDataBrokerCommitQueueSize == null ? 0 : this._maxDataBrokerCommitQueueSize.hashCode());
            result = 31 * result + (this._maxDataBrokerFutureCallbackPoolSize == null ? 0 : this._maxDataBrokerFutureCallbackPoolSize.hashCode());
            result = 31 * result + (this._maxDataBrokerFutureCallbackQueueSize == null ? 0 : this._maxDataBrokerFutureCallbackQueueSize.hashCode());
            result = 31 * result + (this._operationalDataStore == null ? 0 : this._operationalDataStore.hashCode());
            result = 31 * result + (this._schemaService == null ? 0 : this._schemaService.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DomInmemoryDataBroker.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            DomInmemoryDataBroker other = (DomInmemoryDataBroker)obj;
            if (this._configDataStore == null ? other.getConfigDataStore() != null : !this._configDataStore.equals(other.getConfigDataStore())) {
                return false;
            }
            if (this._maxDataBrokerCommitQueueSize == null ? other.getMaxDataBrokerCommitQueueSize() != null : !this._maxDataBrokerCommitQueueSize.equals(other.getMaxDataBrokerCommitQueueSize())) {
                return false;
            }
            if (this._maxDataBrokerFutureCallbackPoolSize == null ? other.getMaxDataBrokerFutureCallbackPoolSize() != null : !this._maxDataBrokerFutureCallbackPoolSize.equals(other.getMaxDataBrokerFutureCallbackPoolSize())) {
                return false;
            }
            if (this._maxDataBrokerFutureCallbackQueueSize == null ? other.getMaxDataBrokerFutureCallbackQueueSize() != null : !this._maxDataBrokerFutureCallbackQueueSize.equals(other.getMaxDataBrokerFutureCallbackQueueSize())) {
                return false;
            }
            if (this._operationalDataStore == null ? other.getOperationalDataStore() != null : !this._operationalDataStore.equals(other.getOperationalDataStore())) {
                return false;
            }
            if (this._schemaService == null ? other.getSchemaService() != null : !this._schemaService.equals(other.getSchemaService())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                DomInmemoryDataBrokerImpl otherImpl = (DomInmemoryDataBrokerImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<DomInmemoryDataBroker>>, Augmentation<DomInmemoryDataBroker>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("DomInmemoryDataBroker [");
            boolean first = true;
            if (this._configDataStore != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_configDataStore=");
                builder.append(this._configDataStore);
            }
            if (this._maxDataBrokerCommitQueueSize != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maxDataBrokerCommitQueueSize=");
                builder.append(this._maxDataBrokerCommitQueueSize);
            }
            if (this._maxDataBrokerFutureCallbackPoolSize != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maxDataBrokerFutureCallbackPoolSize=");
                builder.append(this._maxDataBrokerFutureCallbackPoolSize);
            }
            if (this._maxDataBrokerFutureCallbackQueueSize != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maxDataBrokerFutureCallbackQueueSize=");
                builder.append(this._maxDataBrokerFutureCallbackQueueSize);
            }
            if (this._operationalDataStore != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_operationalDataStore=");
                builder.append(this._operationalDataStore);
            }
            if (this._schemaService != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_schemaService=");
                builder.append(this._schemaService);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

