/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.dom.broker.osgi;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.opendaylight.controller.sal.core.api.BrokerService;
import org.opendaylight.yangtools.concepts.Registration;
import org.osgi.framework.ServiceReference;

public abstract class AbstractBrokerServiceProxy<T extends BrokerService>
implements AutoCloseable,
BrokerService {
    private T delegate;
    private final ServiceReference<T> reference;
    private final Set<Registration> registrations = Collections.synchronizedSet(new HashSet());

    public AbstractBrokerServiceProxy(@Nullable ServiceReference<T> ref, T delegate) {
        this.delegate = (BrokerService)Preconditions.checkNotNull(delegate, (Object)"Delegate should not be null.");
        this.reference = ref;
    }

    protected final T getDelegate() {
        Preconditions.checkState((this.delegate != null ? 1 : 0) != 0, (Object)"Proxy was closed and unregistered.");
        return this.delegate;
    }

    protected final ServiceReference<T> getReference() {
        return this.reference;
    }

    protected <R extends Registration> R addRegistration(R registration) {
        if (registration != null) {
            this.registrations.add(registration);
        }
        return registration;
    }

    protected void closeBeforeUnregistrations() {
    }

    protected void closeAfterUnregistrations() {
    }

    @Override
    public void close() {
        if (this.delegate != null) {
            this.delegate = null;
            RuntimeException potentialException = new RuntimeException("Uncaught exceptions occured during unregistration");
            boolean hasSuppressed = false;
            for (Registration registration : this.registrations) {
                try {
                    registration.close();
                }
                catch (Exception e) {
                    potentialException.addSuppressed(e);
                    hasSuppressed = true;
                }
            }
            if (hasSuppressed) {
                throw potentialException;
            }
        }
    }
}

