/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.dom.broker.impl;

import org.opendaylight.controller.sal.core.api.model.SchemaService;
import org.opendaylight.yangtools.concepts.Delegator;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextProvider;

public class SchemaContextProviders {
    public static final SchemaContextProvider fromSchemaService(SchemaService schemaService) {
        if (schemaService instanceof SchemaContextProvider) {
            return (SchemaContextProvider)schemaService;
        }
        return new SchemaServiceAdapter(schemaService);
    }

    private static final class SchemaServiceAdapter
    implements SchemaContextProvider,
    Delegator<SchemaService> {
        private final SchemaService service;

        public SchemaServiceAdapter(SchemaService service) {
            this.service = service;
        }

        public SchemaContext getSchemaContext() {
            return this.service.getGlobalContext();
        }

        public SchemaService getDelegate() {
            return this.service;
        }

        public String toString() {
            return "SchemaServiceAdapter [service=" + this.service + "]";
        }
    }
}

