/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.dom.broker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import org.opendaylight.controller.sal.core.api.model.SchemaService;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.util.ListenerRegistry;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextListener;
import org.opendaylight.yangtools.yang.model.api.SchemaContextProvider;
import org.opendaylight.yangtools.yang.parser.repo.URLRegistration;
import org.opendaylight.yangtools.yang.parser.repo.URLSchemaContextResolver;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalBundleScanningSchemaServiceImpl
implements SchemaContextProvider,
SchemaService,
ServiceTrackerCustomizer<SchemaContextListener, SchemaContextListener>,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalBundleScanningSchemaServiceImpl.class);
    private final ListenerRegistry<SchemaContextListener> listeners = new ListenerRegistry();
    private final URLSchemaContextResolver contextResolver = URLSchemaContextResolver.create((String)"global-bundle");
    private final BundleScanner scanner = new BundleScanner();
    private final BundleContext context;
    private ServiceTracker<SchemaContextListener, SchemaContextListener> listenerTracker;
    private BundleTracker<Iterable<Registration>> bundleTracker;
    private boolean starting = true;
    private static GlobalBundleScanningSchemaServiceImpl instance;

    private GlobalBundleScanningSchemaServiceImpl(BundleContext context) {
        this.context = (BundleContext)Preconditions.checkNotNull((Object)context);
    }

    public static synchronized GlobalBundleScanningSchemaServiceImpl createInstance(BundleContext ctx) {
        Preconditions.checkState((instance == null ? 1 : 0) != 0);
        instance = new GlobalBundleScanningSchemaServiceImpl(ctx);
        instance.start();
        return instance;
    }

    public static synchronized GlobalBundleScanningSchemaServiceImpl getInstance() {
        Preconditions.checkState((instance != null ? 1 : 0) != 0, (Object)"Global Instance was not instantiated");
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static synchronized void destroyInstance() {
        try {
            instance.close();
        }
        finally {
            instance = null;
        }
    }

    public BundleContext getContext() {
        return this.context;
    }

    public void start() {
        Preconditions.checkState((this.context != null ? 1 : 0) != 0);
        LOG.debug("start() starting");
        this.listenerTracker = new ServiceTracker(this.context, SchemaContextListener.class, (ServiceTrackerCustomizer)this);
        this.bundleTracker = new BundleTracker(this.context, 60, (BundleTrackerCustomizer)this.scanner);
        this.bundleTracker.open();
        LOG.debug("BundleTracker.open() complete");
        this.listenerTracker.open();
        this.starting = false;
        this.tryToUpdateSchemaContext();
        LOG.debug("start() complete");
    }

    public SchemaContext getSchemaContext() {
        return this.getGlobalContext();
    }

    public SchemaContext getGlobalContext() {
        return (SchemaContext)this.contextResolver.getSchemaContext().orNull();
    }

    public void addModule(Module module) {
        throw new UnsupportedOperationException();
    }

    public SchemaContext getSessionContext() {
        throw new UnsupportedOperationException();
    }

    public void removeModule(Module module) {
        throw new UnsupportedOperationException();
    }

    public synchronized ListenerRegistration<SchemaContextListener> registerSchemaContextListener(SchemaContextListener listener) {
        Optional potentialCtx = this.contextResolver.getSchemaContext();
        if (potentialCtx.isPresent()) {
            listener.onGlobalContextUpdated((SchemaContext)potentialCtx.get());
        }
        return this.listeners.register((EventListener)listener);
    }

    @Override
    public void close() {
        if (this.bundleTracker != null) {
            this.bundleTracker.close();
        }
        if (this.listenerTracker != null) {
            this.listenerTracker.close();
        }
        for (ListenerRegistration l : this.listeners.getListeners()) {
            l.close();
        }
    }

    private synchronized void updateContext(SchemaContext snapshot) {
        Object[] services = this.listenerTracker.getServices();
        for (ListenerRegistration listener : this.listeners) {
            try {
                ((SchemaContextListener)listener.getInstance()).onGlobalContextUpdated(snapshot);
            }
            catch (Exception e) {
                LOG.error("Exception occured during invoking listener", (Throwable)e);
            }
        }
        if (services != null) {
            for (Object rawListener : services) {
                SchemaContextListener listener = (SchemaContextListener)rawListener;
                try {
                    listener.onGlobalContextUpdated(snapshot);
                }
                catch (Exception e) {
                    LOG.error("Exception occured during invoking listener {}", (Object)listener, (Object)e);
                }
            }
        }
    }

    public synchronized SchemaContextListener addingService(ServiceReference<SchemaContextListener> reference) {
        SchemaContextListener listener = (SchemaContextListener)this.context.getService(reference);
        SchemaContext _ctxContext = this.getGlobalContext();
        if (this.getContext() != null && _ctxContext != null) {
            listener.onGlobalContextUpdated(_ctxContext);
        }
        return listener;
    }

    public synchronized void tryToUpdateSchemaContext() {
        if (this.starting) {
            return;
        }
        Optional schema = this.contextResolver.getSchemaContext();
        if (schema.isPresent()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got new SchemaContext: # of modules {}", (Object)((SchemaContext)schema.get()).getAllModuleIdentifiers().size());
            }
            this.updateContext((SchemaContext)schema.get());
        }
    }

    public void modifiedService(ServiceReference<SchemaContextListener> reference, SchemaContextListener service) {
    }

    public void removedService(ServiceReference<SchemaContextListener> reference, SchemaContextListener service) {
        this.context.ungetService(reference);
    }

    private class BundleScanner
    implements BundleTrackerCustomizer<Iterable<Registration>> {
        private BundleScanner() {
        }

        public Iterable<Registration> addingBundle(Bundle bundle, BundleEvent event) {
            if (bundle.getBundleId() == 0L) {
                return Collections.emptyList();
            }
            Enumeration enumeration = bundle.findEntries("META-INF/yang", "*.yang", false);
            if (enumeration == null) {
                return Collections.emptyList();
            }
            ArrayList<URLRegistration> urls = new ArrayList<URLRegistration>();
            while (enumeration.hasMoreElements()) {
                URL u = (URL)enumeration.nextElement();
                try {
                    urls.add(GlobalBundleScanningSchemaServiceImpl.this.contextResolver.registerSource(u));
                    LOG.debug("Registered {}", (Object)u);
                }
                catch (Exception e) {
                    LOG.warn("Failed to register {}, ignoring it", (Throwable)e);
                }
            }
            if (!urls.isEmpty()) {
                LOG.debug("Loaded {} new URLs from bundle {}, attempting to rebuild schema context", (Object)urls.size(), (Object)bundle.getSymbolicName());
                GlobalBundleScanningSchemaServiceImpl.this.tryToUpdateSchemaContext();
            }
            return ImmutableList.copyOf(urls);
        }

        public void modifiedBundle(Bundle bundle, BundleEvent event, Iterable<Registration> object) {
        }

        public synchronized void removedBundle(Bundle bundle, BundleEvent event, Iterable<Registration> urls) {
            for (Registration url : urls) {
                try {
                    url.close();
                }
                catch (Exception e) {
                    LOG.warn("Failed do unregister URL {}, proceeding", (Object)url, (Object)e);
                }
            }
            int numUrls = Iterables.size(urls);
            if (numUrls > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("removedBundle: {}, state: {}, # urls: {}", new Object[]{bundle.getSymbolicName(), bundle.getState(), numUrls});
                }
                GlobalBundleScanningSchemaServiceImpl.this.tryToUpdateSchemaContext();
            }
        }
    }
}

