/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.dom.broker;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import java.util.Collection;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.controller.sal.core.api.Broker;
import org.opendaylight.controller.sal.core.api.BrokerService;
import org.opendaylight.controller.sal.core.api.Consumer;
import org.opendaylight.controller.sal.dom.broker.BrokerImpl;
import org.opendaylight.controller.sal.dom.broker.osgi.AbstractBrokerServiceProxy;
import org.opendaylight.controller.sal.dom.broker.osgi.ProxyFactory;

class ConsumerContextImpl
implements Broker.ConsumerSession {
    private final ClassToInstanceMap<BrokerService> instantiatedServices = MutableClassToInstanceMap.create();
    private final Consumer consumer;
    private BrokerImpl broker = null;
    @GuardedBy(value="this")
    private boolean closed = false;

    public ConsumerContextImpl(Consumer provider, BrokerImpl brokerImpl) {
        this.broker = brokerImpl;
        this.consumer = provider;
    }

    public <T extends BrokerService> T getService(Class<T> service) {
        this.checkNotClosed();
        BrokerService localProxy = (BrokerService)this.instantiatedServices.getInstance(service);
        if (localProxy != null) {
            return (T)localProxy;
        }
        Optional<T> serviceImpl = this.broker.getGlobalService(service);
        if (serviceImpl.isPresent()) {
            BrokerService ret = ProxyFactory.createProxy(null, (BrokerService)serviceImpl.get());
            this.instantiatedServices.putInstance(service, (Object)ret);
            return (T)ret;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ConsumerContextImpl consumerContextImpl = this;
        synchronized (consumerContextImpl) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        Collection toStop = this.instantiatedServices.values();
        for (BrokerService brokerService : toStop) {
            if (!(brokerService instanceof AbstractBrokerServiceProxy)) continue;
            ((AbstractBrokerServiceProxy)brokerService).close();
        }
        this.broker.consumerSessionClosed(this);
        this.broker = null;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    protected final BrokerImpl getBrokerChecked() {
        this.checkNotClosed();
        return this.broker;
    }

    public Consumer getConsumer() {
        return this.consumer;
    }

    protected final void checkNotClosed() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Session is closed.");
    }
}

