/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.dom.broker;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.util.concurrent.CheckedFuture;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcAvailabilityListener;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcException;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcIdentifier;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcImplementation;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcImplementationRegistration;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcProviderService;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcResult;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcService;
import org.opendaylight.controller.md.sal.dom.broker.impl.DOMRpcRouter;
import org.opendaylight.controller.sal.core.api.Broker;
import org.opendaylight.controller.sal.core.api.BrokerService;
import org.opendaylight.controller.sal.core.api.Consumer;
import org.opendaylight.controller.sal.core.api.Provider;
import org.opendaylight.controller.sal.dom.broker.ConsumerContextImpl;
import org.opendaylight.controller.sal.dom.broker.ProviderContextImpl;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerImpl
implements Broker,
DOMRpcProviderService,
DOMRpcService,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(BrokerImpl.class);
    private final Set<ConsumerContextImpl> sessions = Collections.synchronizedSet(new HashSet());
    private final Set<ProviderContextImpl> providerSessions = Collections.synchronizedSet(new HashSet());
    private AutoCloseable deactivator = null;
    private DOMRpcRouter router = null;
    private final ClassToInstanceMap<BrokerService> services;

    public BrokerImpl(DOMRpcRouter router, ClassToInstanceMap<BrokerService> services) {
        this.router = (DOMRpcRouter)Preconditions.checkNotNull((Object)router, (Object)"RPC Router must not be null");
        this.services = ImmutableClassToInstanceMap.copyOf(services);
    }

    public Broker.ConsumerSession registerConsumer(Consumer consumer, BundleContext ctx) {
        return this.registerConsumer(consumer);
    }

    public Broker.ProviderSession registerProvider(Provider provider, BundleContext ctx) {
        return this.registerProvider(provider);
    }

    private void checkPredicates(Provider prov) {
        Preconditions.checkNotNull((Object)prov, (Object)"Provider should not be null.");
        for (ProviderContextImpl session : this.providerSessions) {
            if (!prov.equals(session.getProvider())) continue;
            throw new IllegalStateException("Provider already registered");
        }
    }

    private void checkPredicates(Consumer cons) {
        Preconditions.checkNotNull((Object)cons, (Object)"Consumer should not be null.");
        for (ConsumerContextImpl session : this.sessions) {
            if (!cons.equals(session.getConsumer())) continue;
            throw new IllegalStateException("Consumer already registered");
        }
    }

    private ConsumerContextImpl newSessionFor(Consumer provider) {
        ConsumerContextImpl ret = new ConsumerContextImpl(provider, this);
        return ret;
    }

    private ProviderContextImpl newSessionFor(Provider provider) {
        ProviderContextImpl ret = new ProviderContextImpl(provider, this);
        return ret;
    }

    protected void consumerSessionClosed(ConsumerContextImpl consumerContextImpl) {
        this.sessions.remove(consumerContextImpl);
        this.providerSessions.remove(consumerContextImpl);
    }

    @Override
    public void close() throws Exception {
        if (this.deactivator != null) {
            this.deactivator.close();
            this.deactivator = null;
        }
    }

    public AutoCloseable getDeactivator() {
        return this.deactivator;
    }

    public void setDeactivator(AutoCloseable deactivator) {
        this.deactivator = deactivator;
    }

    public DOMRpcRouter getRouter() {
        return this.router;
    }

    public void setRouter(DOMRpcRouter router) {
        this.router = router;
    }

    protected <T extends BrokerService> Optional<T> getGlobalService(Class<T> service) {
        return Optional.fromNullable((Object)this.services.getInstance(service));
    }

    public Broker.ConsumerSession registerConsumer(Consumer consumer) {
        this.checkPredicates(consumer);
        log.trace("Registering consumer {}", (Object)consumer);
        ConsumerContextImpl session = this.newSessionFor(consumer);
        consumer.onSessionInitiated((Broker.ConsumerSession)session);
        this.sessions.add(session);
        return session;
    }

    public Broker.ProviderSession registerProvider(Provider provider) {
        this.checkPredicates(provider);
        ProviderContextImpl session = this.newSessionFor(provider);
        provider.onSessionInitiated((Broker.ProviderSession)session);
        this.providerSessions.add(session);
        return session;
    }

    @Nonnull
    public <T extends DOMRpcImplementation> DOMRpcImplementationRegistration<T> registerRpcImplementation(@Nonnull T implementation, DOMRpcIdentifier ... rpcs) {
        return this.router.registerRpcImplementation(implementation, rpcs);
    }

    @Nonnull
    public <T extends DOMRpcImplementation> DOMRpcImplementationRegistration<T> registerRpcImplementation(@Nonnull T implementation, @Nonnull Set<DOMRpcIdentifier> rpcs) {
        return this.router.registerRpcImplementation(implementation, rpcs);
    }

    @Nonnull
    public CheckedFuture<DOMRpcResult, DOMRpcException> invokeRpc(@Nonnull SchemaPath type, @Nullable NormalizedNode<?, ?> input) {
        return this.router.invokeRpc(type, input);
    }

    @Nonnull
    public <T extends DOMRpcAvailabilityListener> ListenerRegistration<T> registerRpcListener(@Nonnull T listener) {
        return this.router.registerRpcListener(listener);
    }
}

