/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.broker.impl;

import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import java.util.List;
import java.util.Map;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcException;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcImplementation;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcImplementationNotAvailableException;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcResult;
import org.opendaylight.controller.md.sal.dom.broker.impl.AbstractDOMRpcRoutingTableEntry;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

final class UnknownDOMRpcRoutingTableEntry
extends AbstractDOMRpcRoutingTableEntry {
    private final CheckedFuture<DOMRpcResult, DOMRpcException> unknownRpc;

    UnknownDOMRpcRoutingTableEntry(SchemaPath schemaPath, Map<YangInstanceIdentifier, List<DOMRpcImplementation>> impls) {
        super(schemaPath, impls);
        this.unknownRpc = Futures.immediateFailedCheckedFuture((Exception)new DOMRpcImplementationNotAvailableException("SchemaPath %s is not resolved to an RPC", new Object[]{schemaPath}));
    }

    @Override
    protected CheckedFuture<DOMRpcResult, DOMRpcException> invokeRpc(NormalizedNode<?, ?> input) {
        return this.unknownRpc;
    }

    @Override
    protected UnknownDOMRpcRoutingTableEntry newInstance(Map<YangInstanceIdentifier, List<DOMRpcImplementation>> impls) {
        return new UnknownDOMRpcRoutingTableEntry(this.getSchemaPath(), impls);
    }
}

