/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.broker.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeListener;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeProducer;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeService;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeShard;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeShardingConflictException;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeShardingService;
import org.opendaylight.controller.md.sal.dom.broker.impl.ShardRegistration;
import org.opendaylight.controller.md.sal.dom.broker.impl.ShardedDOMDataTreeProducer;
import org.opendaylight.controller.md.sal.dom.broker.impl.ShardingTableEntry;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShardedDOMDataTree
implements DOMDataTreeService,
DOMDataTreeShardingService {
    private static final Logger LOG = LoggerFactory.getLogger(ShardedDOMDataTree.class);
    private final Map<LogicalDatastoreType, ShardingTableEntry> shardingTables = new EnumMap<LogicalDatastoreType, ShardingTableEntry>(LogicalDatastoreType.class);
    @GuardedBy(value="this")
    private final Map<DOMDataTreeIdentifier, DOMDataTreeProducer> idToProducer = new TreeMap<DOMDataTreeIdentifier, DOMDataTreeProducer>();

    @GuardedBy(value="this")
    private ShardingTableEntry lookupShard(DOMDataTreeIdentifier prefix) {
        ShardingTableEntry t = this.shardingTables.get(prefix.getDatastoreType());
        if (t == null) {
            return null;
        }
        return t.lookup(prefix.getRootIdentifier());
    }

    @GuardedBy(value="this")
    private void storeShard(DOMDataTreeIdentifier prefix, ShardRegistration<?> reg) {
        ShardingTableEntry t = this.shardingTables.get(prefix.getDatastoreType());
        if (t == null) {
            t = new ShardingTableEntry();
            this.shardingTables.put(prefix.getDatastoreType(), t);
        }
        t.store(prefix.getRootIdentifier(), reg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeShard(ShardRegistration<?> reg) {
        ShardRegistration<?> parentReg;
        DOMDataTreeIdentifier prefix = reg.getPrefix();
        ShardedDOMDataTree shardedDOMDataTree = this;
        synchronized (shardedDOMDataTree) {
            ShardingTableEntry t = this.shardingTables.get(prefix.getDatastoreType());
            if (t == null) {
                LOG.warn("Shard registration {} points to non-existent table", reg);
                return;
            }
            t.remove(prefix.getRootIdentifier());
            parentReg = this.lookupShard(prefix).getRegistration();
        }
        if (parentReg != null) {
            ((DOMDataTreeShard)parentReg.getInstance()).onChildDetached(prefix, (DOMDataTreeShard)reg.getInstance());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends DOMDataTreeShard> ListenerRegistration<T> registerDataTreeShard(DOMDataTreeIdentifier prefix, T shard) throws DOMDataTreeShardingConflictException {
        ShardRegistration<T> reg;
        ShardRegistration<?> parentReg;
        ShardedDOMDataTree shardedDOMDataTree = this;
        synchronized (shardedDOMDataTree) {
            ShardingTableEntry parent = this.lookupShard(prefix);
            parentReg = parent.getRegistration();
            if (parentReg != null && prefix.equals((Object)parentReg.getPrefix())) {
                throw new DOMDataTreeShardingConflictException(String.format("Prefix %s is already occupied by shard {}", prefix, parentReg.getInstance()));
            }
            reg = new ShardRegistration<T>(this, prefix, shard);
            this.storeShard(prefix, reg);
        }
        if (parentReg != null) {
            ((DOMDataTreeShard)parentReg.getInstance()).onChildAttached(prefix, shard);
        }
        return reg;
    }

    @GuardedBy(value="this")
    private DOMDataTreeProducer findProducer(DOMDataTreeIdentifier subtree) {
        for (Map.Entry<DOMDataTreeIdentifier, DOMDataTreeProducer> e : this.idToProducer.entrySet()) {
            if (!e.getKey().contains(subtree)) continue;
            return e.getValue();
        }
        return null;
    }

    synchronized void destroyProducer(ShardedDOMDataTreeProducer producer) {
        for (DOMDataTreeIdentifier s : producer.getSubtrees()) {
            DOMDataTreeProducer r = this.idToProducer.remove(s);
            if (producer.equals(r)) continue;
            LOG.error("Removed producer %s on subtree %s while removing %s", new Object[]{r, s, producer});
        }
    }

    @GuardedBy(value="this")
    private DOMDataTreeProducer createProducer(Map<DOMDataTreeIdentifier, DOMDataTreeShard> shardMap) {
        DOMDataTreeProducer ret = ShardedDOMDataTreeProducer.create(this, shardMap);
        for (DOMDataTreeIdentifier s : shardMap.keySet()) {
            this.idToProducer.put(s, ret);
        }
        return ret;
    }

    public synchronized DOMDataTreeProducer createProducer(Collection<DOMDataTreeIdentifier> subtrees) {
        Preconditions.checkArgument((!subtrees.isEmpty() ? 1 : 0) != 0, (Object)"Subtrees may not be empty");
        HashMap<DOMDataTreeIdentifier, DOMDataTreeShard> shardMap = new HashMap<DOMDataTreeIdentifier, DOMDataTreeShard>();
        for (DOMDataTreeIdentifier s : subtrees) {
            DOMDataTreeProducer producer = this.findProducer(s);
            Preconditions.checkArgument((producer == null ? 1 : 0) != 0, (String)"Subtree %s is attached to producer %s", (Object[])new Object[]{s, producer});
            shardMap.put(s, (DOMDataTreeShard)this.lookupShard(s).getRegistration().getInstance());
        }
        return this.createProducer(shardMap);
    }

    synchronized DOMDataTreeProducer createProducer(ShardedDOMDataTreeProducer parent, Collection<DOMDataTreeIdentifier> subtrees) {
        Preconditions.checkNotNull((Object)parent);
        HashMap<DOMDataTreeIdentifier, DOMDataTreeShard> shardMap = new HashMap<DOMDataTreeIdentifier, DOMDataTreeShard>();
        for (DOMDataTreeIdentifier s : subtrees) {
            shardMap.put(s, (DOMDataTreeShard)this.lookupShard(s).getRegistration().getInstance());
        }
        return this.createProducer(shardMap);
    }

    public synchronized <T extends DOMDataTreeListener> ListenerRegistration<T> registerListener(T listener, Collection<DOMDataTreeIdentifier> subtrees, boolean allowRxMerges, Collection<DOMDataTreeProducer> producers) {
        return null;
    }
}

