/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.broker.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import org.opendaylight.controller.md.sal.common.api.TransactionStatus;
import org.opendaylight.controller.md.sal.common.api.data.TransactionCommitFailedException;
import org.opendaylight.controller.md.sal.common.impl.service.AbstractDataTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadWriteTransaction;
import org.opendaylight.controller.md.sal.dom.broker.impl.PingPongFuture;
import org.opendaylight.yangtools.yang.common.RpcResult;

final class PingPongTransaction
implements FutureCallback<Void> {
    private final CheckedFuture<Void, TransactionCommitFailedException> submitFuture;
    private final ListenableFuture<RpcResult<TransactionStatus>> commitFuture;
    private final DOMDataReadWriteTransaction delegate;
    private final SettableFuture<Void> future;
    private DOMDataReadWriteTransaction frontendTransaction;

    PingPongTransaction(DOMDataReadWriteTransaction delegate) {
        this.delegate = (DOMDataReadWriteTransaction)Preconditions.checkNotNull((Object)delegate);
        this.future = SettableFuture.create();
        this.submitFuture = new PingPongFuture((ListenableFuture<Void>)this.future);
        this.commitFuture = AbstractDataTransaction.convertToLegacyCommitFuture(this.submitFuture);
    }

    DOMDataReadWriteTransaction getTransaction() {
        return this.delegate;
    }

    DOMDataReadWriteTransaction getFrontendTransaction() {
        return this.frontendTransaction;
    }

    CheckedFuture<Void, TransactionCommitFailedException> getSubmitFuture() {
        return this.submitFuture;
    }

    ListenableFuture<RpcResult<TransactionStatus>> getCommitFuture() {
        return this.commitFuture;
    }

    public void onSuccess(Void result) {
        this.future.set((Object)result);
    }

    public void onFailure(Throwable t) {
        this.future.setException(t);
    }

    void recordFrontendTransaction(DOMDataReadWriteTransaction tx) {
        if (this.frontendTransaction != null) {
            this.frontendTransaction = tx;
        }
    }

    public String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this)).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("delegate", (Object)this.delegate);
    }
}

