/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.broker.impl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcException;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcIdentifier;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcImplementation;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcImplementationNotAvailableException;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcResult;
import org.opendaylight.controller.md.sal.dom.broker.impl.AbstractDOMRpcRoutingTableEntry;
import org.opendaylight.controller.md.sal.dom.broker.impl.GlobalDOMRpcRoutingTableEntry;
import org.opendaylight.controller.md.sal.dom.broker.impl.RoutedDOMRpcRoutingTableEntry;
import org.opendaylight.controller.md.sal.dom.broker.impl.UnknownDOMRpcRoutingTableEntry;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;

final class DOMRpcRoutingTable {
    private static final QName CONTEXT_REFERENCE = QName.cachedReference((QName)QName.create((String)"urn:opendaylight:yang:extension:yang-ext", (String)"2013-07-09", (String)"context-reference"));
    static final DOMRpcRoutingTable EMPTY = new DOMRpcRoutingTable();
    private static final Function<AbstractDOMRpcRoutingTableEntry, Set<YangInstanceIdentifier>> EXTRACT_IDENTIFIERS = new Function<AbstractDOMRpcRoutingTableEntry, Set<YangInstanceIdentifier>>(){

        public Set<YangInstanceIdentifier> apply(AbstractDOMRpcRoutingTableEntry input) {
            return input.registeredIdentifiers();
        }
    };
    private final Map<SchemaPath, AbstractDOMRpcRoutingTableEntry> rpcs;
    private final SchemaContext schemaContext;

    private DOMRpcRoutingTable() {
        this.rpcs = Collections.emptyMap();
        this.schemaContext = null;
    }

    private DOMRpcRoutingTable(Map<SchemaPath, AbstractDOMRpcRoutingTableEntry> rpcs, SchemaContext schemaContext) {
        this.rpcs = (Map)Preconditions.checkNotNull(rpcs);
        this.schemaContext = schemaContext;
    }

    private static ListMultimap<SchemaPath, YangInstanceIdentifier> decomposeIdentifiers(Set<DOMRpcIdentifier> rpcs) {
        LinkedListMultimap ret = LinkedListMultimap.create();
        for (DOMRpcIdentifier i : rpcs) {
            ret.put((Object)i.getType(), (Object)i.getContextReference());
        }
        return ret;
    }

    DOMRpcRoutingTable add(DOMRpcImplementation implementation, Set<DOMRpcIdentifier> rpcs) {
        if (rpcs.isEmpty()) {
            return this;
        }
        ListMultimap<SchemaPath, YangInstanceIdentifier> toAdd = DOMRpcRoutingTable.decomposeIdentifiers(rpcs);
        ImmutableMap.Builder mb = ImmutableMap.builder();
        for (Map.Entry<SchemaPath, AbstractDOMRpcRoutingTableEntry> entry : this.rpcs.entrySet()) {
            ArrayList<YangInstanceIdentifier> newRpcs = new ArrayList<YangInstanceIdentifier>(toAdd.removeAll((Object)entry.getKey()));
            if (!newRpcs.isEmpty()) {
                AbstractDOMRpcRoutingTableEntry ne = entry.getValue().add(implementation, newRpcs);
                mb.put((Object)entry.getKey(), (Object)ne);
                continue;
            }
            mb.put(entry);
        }
        for (Map.Entry<Object, AbstractDOMRpcRoutingTableEntry> entry : toAdd.asMap().entrySet()) {
            ImmutableMap.Builder vb = ImmutableMap.builder();
            List<DOMRpcImplementation> v = Collections.singletonList(implementation);
            for (YangInstanceIdentifier i : (Collection)((Object)entry.getValue())) {
                vb.put((Object)i, v);
            }
            mb.put(entry.getKey(), (Object)DOMRpcRoutingTable.createRpcEntry(this.schemaContext, (SchemaPath)entry.getKey(), (Map<YangInstanceIdentifier, List<DOMRpcImplementation>>)vb.build()));
        }
        return new DOMRpcRoutingTable((Map<SchemaPath, AbstractDOMRpcRoutingTableEntry>)mb.build(), this.schemaContext);
    }

    DOMRpcRoutingTable remove(DOMRpcImplementation implementation, Set<DOMRpcIdentifier> rpcs) {
        if (rpcs.isEmpty()) {
            return this;
        }
        ListMultimap<SchemaPath, YangInstanceIdentifier> toRemove = DOMRpcRoutingTable.decomposeIdentifiers(rpcs);
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (Map.Entry<SchemaPath, AbstractDOMRpcRoutingTableEntry> e : this.rpcs.entrySet()) {
            ArrayList<YangInstanceIdentifier> removed = new ArrayList<YangInstanceIdentifier>(toRemove.removeAll((Object)e.getKey()));
            if (!removed.isEmpty()) {
                AbstractDOMRpcRoutingTableEntry ne = e.getValue().remove(implementation, removed);
                if (ne == null) continue;
                b.put((Object)e.getKey(), (Object)ne);
                continue;
            }
            b.put(e);
        }
        return new DOMRpcRoutingTable((Map<SchemaPath, AbstractDOMRpcRoutingTableEntry>)b.build(), this.schemaContext);
    }

    boolean contains(DOMRpcIdentifier input) {
        AbstractDOMRpcRoutingTableEntry contexts = this.rpcs.get(input.getType());
        return contexts != null && contexts.containsContext(input.getContextReference());
    }

    Map<SchemaPath, Set<YangInstanceIdentifier>> getRpcs() {
        return Maps.transformValues(this.rpcs, EXTRACT_IDENTIFIERS);
    }

    private static RpcDefinition findRpcDefinition(SchemaContext context, SchemaPath schemaPath) {
        QName qname;
        Module module;
        if (context != null && (module = context.findModuleByNamespaceAndRevision((qname = (QName)schemaPath.getPathFromRoot().iterator().next()).getNamespace(), qname.getRevision())) != null && module.getRpcs() != null) {
            for (RpcDefinition rpc : module.getRpcs()) {
                if (!qname.equals((Object)rpc.getQName())) continue;
                return rpc;
            }
        }
        return null;
    }

    private static AbstractDOMRpcRoutingTableEntry createRpcEntry(SchemaContext context, SchemaPath key, Map<YangInstanceIdentifier, List<DOMRpcImplementation>> implementations) {
        RpcDefinition rpcDef = DOMRpcRoutingTable.findRpcDefinition(context, key);
        if (rpcDef != null) {
            ContainerSchemaNode input = rpcDef.getInput();
            if (input != null) {
                for (DataSchemaNode c : input.getChildNodes()) {
                    for (UnknownSchemaNode extension : c.getUnknownSchemaNodes()) {
                        if (!CONTEXT_REFERENCE.equals((Object)extension.getNodeType())) continue;
                        YangInstanceIdentifier keyId = YangInstanceIdentifier.builder().node(c.getQName()).build();
                        return new RoutedDOMRpcRoutingTableEntry(rpcDef, keyId, implementations);
                    }
                }
            }
            return new GlobalDOMRpcRoutingTableEntry(rpcDef, implementations);
        }
        return new UnknownDOMRpcRoutingTableEntry(key, implementations);
    }

    CheckedFuture<DOMRpcResult, DOMRpcException> invokeRpc(SchemaPath type, NormalizedNode<?, ?> input) {
        AbstractDOMRpcRoutingTableEntry entry = this.rpcs.get(type);
        if (entry == null) {
            return Futures.immediateFailedCheckedFuture((Exception)new DOMRpcImplementationNotAvailableException("No implementation of RPC %s available", new Object[]{type}));
        }
        return entry.invokeRpc(input);
    }

    DOMRpcRoutingTable setSchemaContext(SchemaContext context) {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (Map.Entry<SchemaPath, AbstractDOMRpcRoutingTableEntry> e : this.rpcs.entrySet()) {
            b.put((Object)e.getKey(), (Object)DOMRpcRoutingTable.createRpcEntry(context, e.getKey(), e.getValue().getImplementations()));
        }
        return new DOMRpcRoutingTable((Map<SchemaPath, AbstractDOMRpcRoutingTableEntry>)b.build(), context);
    }
}

