/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.broker.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcAvailabilityListener;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcException;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcIdentifier;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcImplementation;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcImplementationRegistration;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcProviderService;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcResult;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcService;
import org.opendaylight.controller.md.sal.dom.broker.impl.DOMRpcRoutingTable;
import org.opendaylight.controller.md.sal.dom.spi.AbstractDOMRpcImplementationRegistration;
import org.opendaylight.yangtools.concepts.AbstractListenerRegistration;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextListener;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

public final class DOMRpcRouter
implements AutoCloseable,
DOMRpcService,
DOMRpcProviderService,
SchemaContextListener {
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactoryBuilder().setNameFormat("DOMRpcRouter-listener-%s").setDaemon(true).build();
    private final ExecutorService listenerNotifier = Executors.newSingleThreadExecutor(THREAD_FACTORY);
    @GuardedBy(value="this")
    private Collection<ListenerRegistration<? extends DOMRpcAvailabilityListener>> listeners = Collections.emptyList();
    private volatile DOMRpcRoutingTable routingTable = DOMRpcRoutingTable.EMPTY;

    public <T extends DOMRpcImplementation> DOMRpcImplementationRegistration<T> registerRpcImplementation(T implementation, DOMRpcIdentifier ... rpcs) {
        return this.registerRpcImplementation(implementation, (Set<DOMRpcIdentifier>)ImmutableSet.copyOf((Object[])rpcs));
    }

    private static Collection<DOMRpcIdentifier> notPresentRpcs(final DOMRpcRoutingTable table, Collection<DOMRpcIdentifier> candidates) {
        return ImmutableSet.copyOf((Collection)Collections2.filter(candidates, (Predicate)new Predicate<DOMRpcIdentifier>(){

            public boolean apply(DOMRpcIdentifier input) {
                return !table.contains(input);
            }
        }));
    }

    private synchronized void removeRpcImplementation(DOMRpcImplementation implementation, Set<DOMRpcIdentifier> rpcs) {
        DOMRpcRoutingTable oldTable = this.routingTable;
        DOMRpcRoutingTable newTable = oldTable.remove(implementation, rpcs);
        final Collection<DOMRpcIdentifier> removedRpcs = DOMRpcRouter.notPresentRpcs(newTable, rpcs);
        this.routingTable = newTable;
        if (!removedRpcs.isEmpty()) {
            final Collection<ListenerRegistration<? extends DOMRpcAvailabilityListener>> capturedListeners = this.listeners;
            this.listenerNotifier.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    for (ListenerRegistration l : capturedListeners) {
                        DOMRpcRouter dOMRpcRouter = DOMRpcRouter.this;
                        synchronized (dOMRpcRouter) {
                            if (DOMRpcRouter.this.listeners.contains(l)) {
                                ((DOMRpcAvailabilityListener)l.getInstance()).onRpcUnavailable(removedRpcs);
                            }
                        }
                    }
                }
            });
        }
    }

    public synchronized <T extends DOMRpcImplementation> DOMRpcImplementationRegistration<T> registerRpcImplementation(T implementation, final Set<DOMRpcIdentifier> rpcs) {
        DOMRpcRoutingTable oldTable = this.routingTable;
        DOMRpcRoutingTable newTable = oldTable.add(implementation, rpcs);
        final Collection<DOMRpcIdentifier> addedRpcs = DOMRpcRouter.notPresentRpcs(oldTable, rpcs);
        this.routingTable = newTable;
        if (!addedRpcs.isEmpty()) {
            final Collection<ListenerRegistration<? extends DOMRpcAvailabilityListener>> capturedListeners = this.listeners;
            this.listenerNotifier.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    for (ListenerRegistration l : capturedListeners) {
                        DOMRpcRouter dOMRpcRouter = DOMRpcRouter.this;
                        synchronized (dOMRpcRouter) {
                            if (DOMRpcRouter.this.listeners.contains(l)) {
                                ((DOMRpcAvailabilityListener)l.getInstance()).onRpcAvailable(addedRpcs);
                            }
                        }
                    }
                }
            });
        }
        return new AbstractDOMRpcImplementationRegistration<T>(implementation){

            protected void removeRegistration() {
                DOMRpcRouter.this.removeRpcImplementation((DOMRpcImplementation)this.getInstance(), rpcs);
            }
        };
    }

    public CheckedFuture<DOMRpcResult, DOMRpcException> invokeRpc(SchemaPath type, NormalizedNode<?, ?> input) {
        return this.routingTable.invokeRpc(type, input);
    }

    private synchronized void removeListener(final ListenerRegistration<? extends DOMRpcAvailabilityListener> reg) {
        this.listeners = ImmutableList.copyOf((Collection)Collections2.filter(this.listeners, (Predicate)new Predicate<Object>(){

            public boolean apply(Object input) {
                return !reg.equals(input);
            }
        }));
    }

    public synchronized <T extends DOMRpcAvailabilityListener> ListenerRegistration<T> registerRpcListener(final T listener) {
        AbstractListenerRegistration ret = new AbstractListenerRegistration<T>(listener){

            protected void removeRegistration() {
                DOMRpcRouter.this.removeListener((ListenerRegistration<? extends DOMRpcAvailabilityListener>)((ListenerRegistration)this));
            }
        };
        ImmutableList.Builder b = ImmutableList.builder();
        b.addAll(this.listeners);
        b.add((Object)ret);
        this.listeners = b.build();
        final Map<SchemaPath, Set<YangInstanceIdentifier>> capturedRpcs = this.routingTable.getRpcs();
        this.listenerNotifier.execute(new Runnable(){

            @Override
            public void run() {
                for (final Map.Entry e : capturedRpcs.entrySet()) {
                    listener.onRpcAvailable(Collections2.transform((Collection)((Collection)e.getValue()), (Function)new Function<YangInstanceIdentifier, DOMRpcIdentifier>(){

                        public DOMRpcIdentifier apply(YangInstanceIdentifier input) {
                            return DOMRpcIdentifier.create((SchemaPath)((SchemaPath)e.getKey()), (YangInstanceIdentifier)input);
                        }
                    }));
                }
            }
        });
        return ret;
    }

    public synchronized void onGlobalContextUpdated(SchemaContext context) {
        DOMRpcRoutingTable newTable;
        DOMRpcRoutingTable oldTable = this.routingTable;
        this.routingTable = newTable = oldTable.setSchemaContext(context);
    }

    @Override
    public void close() {
        this.listenerNotifier.shutdown();
    }
}

