/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.broker.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.InsufficientCapacityException;
import com.lmax.disruptor.PhasedBackoffWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.md.sal.dom.api.DOMNotification;
import org.opendaylight.controller.md.sal.dom.api.DOMNotificationListener;
import org.opendaylight.controller.md.sal.dom.api.DOMNotificationPublishService;
import org.opendaylight.controller.md.sal.dom.api.DOMNotificationService;
import org.opendaylight.controller.md.sal.dom.broker.impl.DOMNotificationRouterEvent;
import org.opendaylight.controller.md.sal.dom.spi.DOMNotificationSubscriptionListener;
import org.opendaylight.controller.md.sal.dom.spi.DOMNotificationSubscriptionListenerRegistry;
import org.opendaylight.yangtools.concepts.AbstractListenerRegistration;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.util.ListenerRegistry;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DOMNotificationRouter
implements AutoCloseable,
DOMNotificationPublishService,
DOMNotificationService,
DOMNotificationSubscriptionListenerRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DOMNotificationRouter.class);
    private static final ListenableFuture<Void> NO_LISTENERS = Futures.immediateFuture(null);
    private static final WaitStrategy DEFAULT_STRATEGY = PhasedBackoffWaitStrategy.withLock((long)1L, (long)30L, (TimeUnit)TimeUnit.MILLISECONDS);
    private static final EventHandler<DOMNotificationRouterEvent> DISPATCH_NOTIFICATIONS = new EventHandler<DOMNotificationRouterEvent>(){

        public void onEvent(DOMNotificationRouterEvent event, long sequence, boolean endOfBatch) throws Exception {
            event.deliverNotification();
        }
    };
    private static final EventHandler<DOMNotificationRouterEvent> NOTIFY_FUTURE = new EventHandler<DOMNotificationRouterEvent>(){

        public void onEvent(DOMNotificationRouterEvent event, long sequence, boolean endOfBatch) {
            event.setFuture();
        }
    };
    private final Disruptor<DOMNotificationRouterEvent> disruptor;
    private final ExecutorService executor;
    private volatile Multimap<SchemaPath, ListenerRegistration<? extends DOMNotificationListener>> listeners = ImmutableMultimap.of();
    private final ListenerRegistry<DOMNotificationSubscriptionListener> subscriptionListeners = ListenerRegistry.create();

    private DOMNotificationRouter(ExecutorService executor, int queueDepth, WaitStrategy strategy) {
        this.executor = (ExecutorService)Preconditions.checkNotNull((Object)executor);
        this.disruptor = new Disruptor(DOMNotificationRouterEvent.FACTORY, queueDepth, (Executor)executor, ProducerType.MULTI, strategy);
        this.disruptor.handleEventsWith(new EventHandler[]{DISPATCH_NOTIFICATIONS});
        this.disruptor.after(new EventHandler[]{DISPATCH_NOTIFICATIONS}).handleEventsWith(new EventHandler[]{NOTIFY_FUTURE});
        this.disruptor.start();
    }

    public static DOMNotificationRouter create(int queueDepth) {
        ExecutorService executor = Executors.newCachedThreadPool();
        return new DOMNotificationRouter(executor, queueDepth, DEFAULT_STRATEGY);
    }

    public static DOMNotificationRouter create(int queueDepth, long spinTime, long parkTime, TimeUnit unit) {
        ExecutorService executor = Executors.newCachedThreadPool();
        PhasedBackoffWaitStrategy strategy = PhasedBackoffWaitStrategy.withLock((long)spinTime, (long)parkTime, (TimeUnit)unit);
        return new DOMNotificationRouter(executor, queueDepth, (WaitStrategy)strategy);
    }

    public synchronized <T extends DOMNotificationListener> ListenerRegistration<T> registerNotificationListener(T listener, Collection<SchemaPath> types) {
        AbstractListenerRegistration reg = new AbstractListenerRegistration<T>(listener){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void removeRegistration() {
                3 me = this;
                DOMNotificationRouter dOMNotificationRouter = DOMNotificationRouter.this;
                synchronized (dOMNotificationRouter) {
                    DOMNotificationRouter.this.replaceListeners((Multimap<SchemaPath, ListenerRegistration<? extends DOMNotificationListener>>)((Multimap)ImmutableMultimap.copyOf((Multimap)Multimaps.filterValues((Multimap)DOMNotificationRouter.this.listeners, (Predicate)new Predicate<ListenerRegistration<? extends DOMNotificationListener>>((ListenerRegistration)me){
                        final /* synthetic */ ListenerRegistration val$me;
                        {
                            this.val$me = listenerRegistration;
                        }

                        public boolean apply(ListenerRegistration<? extends DOMNotificationListener> input) {
                            return input != this.val$me;
                        }
                    }))));
                }
            }
        };
        if (!types.isEmpty()) {
            ImmutableMultimap.Builder b = ImmutableMultimap.builder();
            b.putAll(this.listeners);
            for (SchemaPath t : types) {
                b.put((Object)t, (Object)reg);
            }
            this.replaceListeners((Multimap<SchemaPath, ListenerRegistration<? extends DOMNotificationListener>>)b.build());
        }
        return reg;
    }

    public <T extends DOMNotificationListener> ListenerRegistration<T> registerNotificationListener(T listener, SchemaPath ... types) {
        return this.registerNotificationListener(listener, Arrays.asList(types));
    }

    private void replaceListeners(Multimap<SchemaPath, ListenerRegistration<? extends DOMNotificationListener>> newListeners) {
        this.listeners = newListeners;
        this.notifyListenerTypesChanged(newListeners.keySet());
    }

    private void notifyListenerTypesChanged(Set<SchemaPath> typesAfter) {
        ImmutableList listenersAfter = ImmutableList.copyOf((Iterable)this.subscriptionListeners.getListeners());
        this.executor.submit(new Runnable((List)listenersAfter, typesAfter){
            final /* synthetic */ List val$listenersAfter;
            final /* synthetic */ Set val$typesAfter;
            {
                this.val$listenersAfter = list;
                this.val$typesAfter = set;
            }

            @Override
            public void run() {
                for (ListenerRegistration subListener : this.val$listenersAfter) {
                    try {
                        ((DOMNotificationSubscriptionListener)subListener.getInstance()).onSubscriptionChanged(this.val$typesAfter);
                    }
                    catch (Exception e) {
                        LOG.warn("Uncaught exception during invoking listener {}", subListener.getInstance(), (Object)e);
                    }
                }
            }
        });
    }

    public <L extends DOMNotificationSubscriptionListener> ListenerRegistration<L> registerSubscriptionListener(final L listener) {
        final Set initialTypes = this.listeners.keySet();
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                listener.onSubscriptionChanged(initialTypes);
            }
        });
        return this.subscriptionListeners.registerWithType(listener);
    }

    private ListenableFuture<Void> publish(long seq, DOMNotification notification, Collection<ListenerRegistration<? extends DOMNotificationListener>> subscribers) {
        DOMNotificationRouterEvent event = (DOMNotificationRouterEvent)this.disruptor.get(seq);
        ListenableFuture<Void> future = event.initialize(notification, subscribers);
        this.disruptor.getRingBuffer().publish(seq);
        return future;
    }

    public ListenableFuture<? extends Object> putNotification(DOMNotification notification) throws InterruptedException {
        Collection subscribers = this.listeners.get((Object)notification.getType());
        if (subscribers.isEmpty()) {
            return NO_LISTENERS;
        }
        long seq = this.disruptor.getRingBuffer().next();
        return this.publish(seq, notification, subscribers);
    }

    private ListenableFuture<? extends Object> tryPublish(DOMNotification notification, Collection<ListenerRegistration<? extends DOMNotificationListener>> subscribers) {
        long seq;
        try {
            seq = this.disruptor.getRingBuffer().tryNext();
        }
        catch (InsufficientCapacityException e) {
            return DOMNotificationPublishService.REJECTED;
        }
        return this.publish(seq, notification, subscribers);
    }

    public ListenableFuture<? extends Object> offerNotification(DOMNotification notification) {
        Collection subscribers = this.listeners.get((Object)notification.getType());
        if (subscribers.isEmpty()) {
            return NO_LISTENERS;
        }
        return this.tryPublish(notification, subscribers);
    }

    public ListenableFuture<? extends Object> offerNotification(DOMNotification notification, long timeout, TimeUnit unit) throws InterruptedException {
        Collection subscribers = this.listeners.get((Object)notification.getType());
        if (subscribers.isEmpty()) {
            return NO_LISTENERS;
        }
        ListenableFuture<? extends Object> noBlock = this.tryPublish(notification, subscribers);
        if (!DOMNotificationPublishService.REJECTED.equals(noBlock)) {
            return noBlock;
        }
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void close() {
        this.disruptor.shutdown();
        this.executor.shutdown();
    }
}

