/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.broker.impl;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.CheckedFuture;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.TransactionCommitFailedException;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadOnlyTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadWriteTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMDataWriteTransaction;
import org.opendaylight.controller.md.sal.dom.broker.impl.DOMForwardedReadOnlyTransaction;
import org.opendaylight.controller.md.sal.dom.broker.impl.DOMForwardedReadWriteTransaction;
import org.opendaylight.controller.md.sal.dom.broker.impl.DOMForwardedWriteTransaction;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreReadTransaction;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreReadWriteTransaction;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreTransactionFactory;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreWriteTransaction;

abstract class AbstractDOMForwardedTransactionFactory<T extends DOMStoreTransactionFactory>
implements AutoCloseable {
    private static final AtomicIntegerFieldUpdater<AbstractDOMForwardedTransactionFactory> UPDATER = AtomicIntegerFieldUpdater.newUpdater(AbstractDOMForwardedTransactionFactory.class, "closed");
    private final Map<LogicalDatastoreType, T> storeTxFactories;
    private volatile int closed = 0;

    protected AbstractDOMForwardedTransactionFactory(Map<LogicalDatastoreType, ? extends T> txFactories) {
        this.storeTxFactories = new EnumMap<LogicalDatastoreType, T>(txFactories);
    }

    protected abstract Object newTransactionIdentifier();

    protected abstract CheckedFuture<Void, TransactionCommitFailedException> submit(DOMDataWriteTransaction var1, Collection<DOMStoreThreePhaseCommitCohort> var2);

    public final DOMDataReadOnlyTransaction newReadOnlyTransaction() {
        this.checkNotClosed();
        EnumMap<LogicalDatastoreType, DOMStoreReadTransaction> txns = new EnumMap<LogicalDatastoreType, DOMStoreReadTransaction>(LogicalDatastoreType.class);
        for (Map.Entry<LogicalDatastoreType, T> store : this.storeTxFactories.entrySet()) {
            txns.put(store.getKey(), ((DOMStoreTransactionFactory)store.getValue()).newReadOnlyTransaction());
        }
        return new DOMForwardedReadOnlyTransaction(this.newTransactionIdentifier(), (Map<LogicalDatastoreType, DOMStoreReadTransaction>)txns);
    }

    public final DOMDataWriteTransaction newWriteOnlyTransaction() {
        this.checkNotClosed();
        EnumMap<LogicalDatastoreType, DOMStoreWriteTransaction> txns = new EnumMap<LogicalDatastoreType, DOMStoreWriteTransaction>(LogicalDatastoreType.class);
        for (Map.Entry<LogicalDatastoreType, T> store : this.storeTxFactories.entrySet()) {
            txns.put(store.getKey(), ((DOMStoreTransactionFactory)store.getValue()).newWriteOnlyTransaction());
        }
        return new DOMForwardedWriteTransaction(this.newTransactionIdentifier(), txns, this);
    }

    public final DOMDataReadWriteTransaction newReadWriteTransaction() {
        this.checkNotClosed();
        EnumMap<LogicalDatastoreType, DOMStoreReadWriteTransaction> txns = new EnumMap<LogicalDatastoreType, DOMStoreReadWriteTransaction>(LogicalDatastoreType.class);
        for (Map.Entry<LogicalDatastoreType, T> store : this.storeTxFactories.entrySet()) {
            txns.put(store.getKey(), ((DOMStoreTransactionFactory)store.getValue()).newReadWriteTransaction());
        }
        return new DOMForwardedReadWriteTransaction(this.newTransactionIdentifier(), (Map<LogicalDatastoreType, DOMStoreReadWriteTransaction>)txns, (AbstractDOMForwardedTransactionFactory<?>)this);
    }

    protected final Map<LogicalDatastoreType, T> getTxFactories() {
        return this.storeTxFactories;
    }

    protected final void checkNotClosed() {
        Preconditions.checkState((this.closed == 0 ? 1 : 0) != 0, (Object)"Transaction factory was closed. No further operations allowed.");
    }

    @Override
    public void close() {
        boolean success = UPDATER.compareAndSet(this, 0, 1);
        Preconditions.checkState((boolean)success, (Object)"Transaction factory was already closed");
    }
}

