/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.broker.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import org.opendaylight.controller.md.sal.common.api.data.AsyncTransaction;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreTransaction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

abstract class AbstractDOMForwardedCompositeTransaction<K, T extends DOMStoreTransaction>
implements AsyncTransaction<YangInstanceIdentifier, NormalizedNode<?, ?>> {
    private final Map<K, T> backingTxs;
    private final Object identifier;

    protected AbstractDOMForwardedCompositeTransaction(Object identifier, Map<K, T> backingTxs) {
        this.identifier = Preconditions.checkNotNull((Object)identifier, (Object)"Identifier should not be null");
        this.backingTxs = (Map)Preconditions.checkNotNull(backingTxs, (Object)"Backing transactions should not be null");
    }

    protected final T getSubtransaction(K key) {
        Preconditions.checkNotNull(key, (Object)"key must not be null.");
        DOMStoreTransaction ret = (DOMStoreTransaction)this.backingTxs.get(key);
        Preconditions.checkArgument((ret != null ? 1 : 0) != 0, (String)"No subtransaction associated with %s", (Object[])new Object[]{key});
        return (T)ret;
    }

    protected Collection<T> getSubtransactions() {
        return this.backingTxs.values();
    }

    public Object getIdentifier() {
        return this.identifier;
    }

    protected void closeSubtransactions() {
        Throwable failure = null;
        for (DOMStoreTransaction subtransaction : this.backingTxs.values()) {
            try {
                subtransaction.close();
            }
            catch (Exception e) {
                if (failure == null) {
                    failure = new IllegalStateException("Uncaught exception occured during closing transaction", e);
                    continue;
                }
                failure.addSuppressed(e);
            }
        }
        if (failure != null) {
            throw failure;
        }
    }
}

