/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.md.sal.dom.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.DependencyResolverFactory;
import org.opendaylight.controller.config.api.DynamicMBeanWithInstance;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.AbstractServiceInterface;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.opendaylight.controller.config.yang.md.sal.dom.DOMDataBrokerServiceInterface;
import org.opendaylight.controller.config.yang.md.sal.dom.impl.DomInmemoryDataBrokerModule;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.osgi.framework.BundleContext;

@ModuleQName(revision="2013-10-28", name="opendaylight-sal-dom-broker-impl", namespace="urn:opendaylight:params:xml:ns:yang:controller:md:sal:dom:impl")
public abstract class AbstractDomInmemoryDataBrokerModuleFactory
implements ModuleFactory {
    public static final String NAME = "dom-inmemory-data-broker";
    private static final Set<Class<? extends AbstractServiceInterface>> serviceIfcs;

    public final String getImplementationName() {
        return NAME;
    }

    public final boolean isModuleImplementingServiceInterface(Class<? extends AbstractServiceInterface> serviceInterface) {
        for (Class<? extends AbstractServiceInterface> ifc : serviceIfcs) {
            if (!serviceInterface.isAssignableFrom(ifc)) continue;
            return true;
        }
        return false;
    }

    public Set<Class<? extends AbstractServiceInterface>> getImplementedServiceIntefaces() {
        return serviceIfcs;
    }

    public Module createModule(String instanceName, DependencyResolver dependencyResolver, BundleContext bundleContext) {
        return this.instantiateModule(instanceName, dependencyResolver, bundleContext);
    }

    public Module createModule(String instanceName, DependencyResolver dependencyResolver, DynamicMBeanWithInstance old, BundleContext bundleContext) throws Exception {
        DomInmemoryDataBrokerModule oldModule = null;
        try {
            oldModule = (DomInmemoryDataBrokerModule)old.getModule();
        }
        catch (Exception e) {
            return this.handleChangedClass(old);
        }
        DomInmemoryDataBrokerModule module = this.instantiateModule(instanceName, dependencyResolver, oldModule, old.getInstance(), bundleContext);
        module.setSchemaService(oldModule.getSchemaService());
        module.setMaxDataBrokerFutureCallbackQueueSize(oldModule.getMaxDataBrokerFutureCallbackQueueSize());
        module.setConfigDataStore(oldModule.getConfigDataStore());
        module.setOperationalDataStore(oldModule.getOperationalDataStore());
        module.setMaxDataBrokerCommitQueueSize(oldModule.getMaxDataBrokerCommitQueueSize());
        module.setMaxDataBrokerFutureCallbackPoolSize(oldModule.getMaxDataBrokerFutureCallbackPoolSize());
        return module;
    }

    public DomInmemoryDataBrokerModule instantiateModule(String instanceName, DependencyResolver dependencyResolver, DomInmemoryDataBrokerModule oldModule, AutoCloseable oldInstance, BundleContext bundleContext) {
        return new DomInmemoryDataBrokerModule(new ModuleIdentifier(NAME, instanceName), dependencyResolver, oldModule, oldInstance);
    }

    public DomInmemoryDataBrokerModule instantiateModule(String instanceName, DependencyResolver dependencyResolver, BundleContext bundleContext) {
        return new DomInmemoryDataBrokerModule(new ModuleIdentifier(NAME, instanceName), dependencyResolver);
    }

    public DomInmemoryDataBrokerModule handleChangedClass(DynamicMBeanWithInstance old) throws Exception {
        throw new UnsupportedOperationException("Class reloading is not supported");
    }

    public Set<DomInmemoryDataBrokerModule> getDefaultModules(DependencyResolverFactory dependencyResolverFactory, BundleContext bundleContext) {
        return new HashSet<DomInmemoryDataBrokerModule>();
    }

    static {
        HashSet<Class<DOMDataBrokerServiceInterface>> serviceIfcs2 = new HashSet<Class<DOMDataBrokerServiceInterface>>();
        serviceIfcs2.add(DOMDataBrokerServiceInterface.class);
        serviceIfcs = Collections.unmodifiableSet(serviceIfcs2);
    }
}

