/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.trace.closetracker.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.opendaylight.controller.md.sal.trace.closetracker.impl.CloseTracked;
import org.opendaylight.controller.md.sal.trace.closetracker.impl.CloseTrackedRegistryReportEntry;

@Deprecated(forRemoval=true)
public class CloseTrackedRegistry<T extends CloseTracked<T>> {
    private final Object anchor;
    private final String createDescription;
    private final Set<CloseTracked<T>> tracked = new ConcurrentSkipListSet<CloseTracked>(Comparator.comparingInt(System::identityHashCode));
    private final boolean isDebugContextEnabled;

    public CloseTrackedRegistry(Object anchor, String createDescription, boolean isDebugContextEnabled) {
        this.anchor = anchor;
        this.createDescription = createDescription;
        this.isDebugContextEnabled = isDebugContextEnabled;
    }

    public boolean isDebugContextEnabled() {
        return this.isDebugContextEnabled;
    }

    public Object getAnchor() {
        return this.anchor;
    }

    public String getCreateDescription() {
        return this.createDescription;
    }

    void add(CloseTracked<T> closeTracked) {
        this.tracked.add(closeTracked);
    }

    void remove(CloseTracked<T> closeTracked) {
        this.tracked.remove(closeTracked);
    }

    @SuppressFBWarnings(value={"UC_USELESS_OBJECT"})
    public Set<CloseTrackedRegistryReportEntry<T>> getAllUnique() {
        HashMap<List, Long> map = new HashMap<List, Long>();
        HashSet<CloseTracked<T>> copyOfTracked = new HashSet<CloseTracked<T>>(this.tracked);
        for (CloseTracked closeTracked : copyOfTracked) {
            StackTraceElement[] stackTraceArray = closeTracked.getAllocationContextStackTrace();
            List<Object> stackTraceElements2 = stackTraceArray != null ? Arrays.asList(stackTraceArray) : Collections.emptyList();
            map.merge(stackTraceElements2, 1L, (oldValue, value) -> oldValue + 1L);
        }
        HashSet<CloseTrackedRegistryReportEntry<T>> report = new HashSet<CloseTrackedRegistryReportEntry<T>>();
        map.forEach((stackTraceElements, number) -> copyOfTracked.stream().filter(closeTracked -> {
            StackTraceElement[] closeTrackedStackTraceArray = closeTracked.getAllocationContextStackTrace();
            List<Object> closeTrackedStackTraceElements = closeTrackedStackTraceArray != null ? Arrays.asList(closeTrackedStackTraceArray) : Collections.emptyList();
            return closeTrackedStackTraceElements.equals(stackTraceElements);
        }).findAny().ifPresent(exampleCloseTracked -> report.add(new CloseTrackedRegistryReportEntry(exampleCloseTracked, (long)number, (List<StackTraceElement>)stackTraceElements))));
        return report;
    }
}

