/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.mdsal.it.base;

import javax.inject.Inject;
import org.junit.Before;
import org.opendaylight.controller.config.it.base.AbstractConfigTestBase;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.controller.sal.binding.api.BindingAwareProvider;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.karaf.options.LogLevelOption;
import org.ops4j.pax.exam.util.Filter;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMdsalTestBase
extends AbstractConfigTestBase
implements BindingAwareProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMdsalTestBase.class);
    private static final int REGISTRATION_TIMEOUT = 70000;
    @Inject
    @Filter(timeout=60000L)
    private BundleContext context;
    @Inject
    @Filter(timeout=60000L)
    private BindingAwareBroker broker;
    private BindingAwareBroker.ProviderContext session = null;

    public BindingAwareBroker.ProviderContext getSession() {
        return this.session;
    }

    public void onSessionInitiated(BindingAwareBroker.ProviderContext session) {
        LOG.info("Session Initiated: {}", (Object)session);
        this.session = session;
    }

    @Before
    public void setup() throws Exception {
        super.setup();
        long start = System.nanoTime();
        this.broker.registerProvider((BindingAwareProvider)this);
        for (int i = 0; i < 70000; ++i) {
            if (this.session != null) {
                long stop = System.nanoTime();
                LOG.info("Registered session {} with the MD-SAL after {} ns", (Object)this.session, (Object)(stop - start));
                return;
            }
            Thread.sleep(1L);
        }
        throw new RuntimeException("Session not initiated after 70000 ms");
    }

    public Option getLoggingOption() {
        Option option = KarafDistributionOption.editConfigurationFilePut((String)"etc/org.ops4j.pax.logging.cfg", (String)this.logConfiguration(AbstractMdsalTestBase.class), (Object)LogLevelOption.LogLevel.INFO.name());
        option = CoreOptions.composite((Option[])new Option[]{option, super.getLoggingOption()});
        return option;
    }
}

