/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.api;

import org.opendaylight.yangtools.concepts.Identifier;

public class ModuleIdentifier
implements Identifier {
    private static final long serialVersionUID = 1L;
    private final String factoryName;
    private final String instanceName;

    public ModuleIdentifier(String factoryName, String instanceName) {
        if (factoryName == null) {
            throw new IllegalArgumentException("Parameter 'factoryName' is null");
        }
        if (instanceName == null) {
            throw new IllegalArgumentException("Parameter 'instanceName' is null");
        }
        this.factoryName = factoryName;
        this.instanceName = instanceName;
    }

    public String getFactoryName() {
        return this.factoryName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleIdentifier that = (ModuleIdentifier)o;
        if (!this.factoryName.equals(that.factoryName)) {
            return false;
        }
        return this.instanceName.equals(that.instanceName);
    }

    public int hashCode() {
        int result = this.factoryName.hashCode();
        result = 31 * result + this.instanceName.hashCode();
        return result;
    }

    public String toString() {
        return "ModuleIdentifier{factoryName='" + this.factoryName + '\'' + ", instanceName='" + this.instanceName + '\'' + '}';
    }
}

