/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.concepts;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.WritableIdentifier;

@Beta
public final class MemberName
implements Comparable<MemberName>,
WritableIdentifier {
    private static final long serialVersionUID = 1L;
    private final @NonNull String name;
    @SuppressFBWarnings(value={"VO_VOLATILE_REFERENCE_TO_ARRAY"}, justification="The array elements are non-volatile but we don't access them.")
    private volatile byte[] serialized;

    private MemberName(String name) {
        this.name = Objects.requireNonNull(name);
    }

    MemberName(String name, byte[] serialized) {
        this(name);
        this.serialized = (byte[])Verify.verifyNotNull((Object)serialized);
    }

    public static @NonNull MemberName forName(String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        return new MemberName(name);
    }

    public static @NonNull MemberName readFrom(DataInput in) throws IOException {
        byte[] serialized = new byte[in.readInt()];
        in.readFully(serialized);
        return new MemberName(new String(serialized, StandardCharsets.UTF_8));
    }

    public void writeTo(DataOutput out) throws IOException {
        byte[] local = this.getSerialized();
        out.writeInt(local.length);
        out.write(local);
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.cds.types.rev191024.MemberName toYang() {
        return new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.cds.types.rev191024.MemberName(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof MemberName && this.name.equals(((MemberName)obj).name);
    }

    @Override
    public int compareTo(MemberName obj) {
        return this == obj ? 0 : this.name.compareTo(obj.name);
    }

    public String toString() {
        return MoreObjects.toStringHelper(MemberName.class).add("name", (Object)this.name).toString();
    }

    private byte[] getSerialized() {
        byte[] local = this.serialized;
        if (local == null) {
            this.serialized = local = this.name.getBytes(StandardCharsets.UTF_8);
        }
        return local;
    }

    Object writeReplace() {
        return new Proxy(this.getSerialized());
    }

    private static final class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private byte[] serialized;

        public Proxy() {
        }

        Proxy(byte[] serialized) {
            this.serialized = Objects.requireNonNull(serialized);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.serialized.length);
            out.write(this.serialized);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.serialized = new byte[in.readInt()];
            in.readFully(this.serialized);
        }

        private Object readResolve() {
            return new MemberName(new String(this.serialized, StandardCharsets.UTF_8), this.serialized);
        }
    }
}

