/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import akka.actor.ActorRef;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.UnsignedLong;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.opendaylight.controller.cluster.access.commands.AbstractTransactionRequestProxy;
import org.opendaylight.controller.cluster.access.commands.SkipTransactionsRequest;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.yangtools.concepts.WritableObjects;

final class SkipTransactionsRequestV1
extends AbstractTransactionRequestProxy<SkipTransactionsRequest> {
    private List<UnsignedLong> others;

    public SkipTransactionsRequestV1() {
    }

    SkipTransactionsRequestV1(SkipTransactionsRequest request) {
        super(request);
        this.others = request.getOthers();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int idx;
        super.readExternal(in);
        int size = in.readInt();
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)size);
        if (size % 2 != 0) {
            builder.add((Object)UnsignedLong.fromLongBits((long)WritableObjects.readLong((DataInput)in)));
            idx = 1;
        } else {
            idx = 0;
        }
        while (idx < size) {
            byte hdr = WritableObjects.readLongHeader((DataInput)in);
            builder.add((Object)UnsignedLong.fromLongBits((long)WritableObjects.readFirstLong((DataInput)in, (byte)hdr)));
            builder.add((Object)UnsignedLong.fromLongBits((long)WritableObjects.readSecondLong((DataInput)in, (byte)hdr)));
            idx += 2;
        }
        this.others = builder.build();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int idx;
        super.writeExternal(out);
        int size = this.others.size();
        out.writeInt(size);
        if (size % 2 != 0) {
            WritableObjects.writeLong((DataOutput)out, (long)this.others.get(0).longValue());
            idx = 1;
        } else {
            idx = 0;
        }
        while (idx < size) {
            WritableObjects.writeLongs((DataOutput)out, (long)this.others.get(idx).longValue(), (long)this.others.get(idx + 1).longValue());
            idx += 2;
        }
    }

    @Override
    protected SkipTransactionsRequest createRequest(TransactionIdentifier target, long sequence, ActorRef replyToActor) {
        return new SkipTransactionsRequest(target, sequence, replyToActor, this.others);
    }
}

