/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestStatus;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

public class TestStatusBuilder
implements Builder<TestStatus> {
    private TestStatus.ExecStatus _execStatus;
    private Uint32 _testsCompleted;
    Map<Class<? extends Augmentation<TestStatus>>, Augmentation<TestStatus>> augmentation = Collections.emptyMap();

    public TestStatusBuilder() {
    }

    public TestStatusBuilder(TestStatus base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TestStatus>>, Augmentation<TestStatus>>(aug);
        }
        this._execStatus = base.getExecStatus();
        this._testsCompleted = base.getTestsCompleted();
    }

    public TestStatus.ExecStatus getExecStatus() {
        return this._execStatus;
    }

    public Uint32 getTestsCompleted() {
        return this._testsCompleted;
    }

    public <E$$ extends Augmentation<TestStatus>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public TestStatusBuilder setExecStatus(TestStatus.ExecStatus value) {
        this._execStatus = value;
        return this;
    }

    public TestStatusBuilder setTestsCompleted(Uint32 value) {
        this._testsCompleted = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public TestStatusBuilder setTestsCompleted(Long value) {
        return this.setTestsCompleted(CodeHelpers.compatUint((Long)value));
    }

    public TestStatusBuilder addAugmentation(Class<? extends Augmentation<TestStatus>> augmentationType, Augmentation<TestStatus> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TestStatus>>, Augmentation<TestStatus>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public TestStatusBuilder removeAugmentation(Class<? extends Augmentation<TestStatus>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public TestStatus build() {
        return new TestStatusImpl(this);
    }

    private static final class TestStatusImpl
    extends AbstractAugmentable<TestStatus>
    implements TestStatus {
        private final TestStatus.ExecStatus _execStatus;
        private final Uint32 _testsCompleted;
        private int hash = 0;
        private volatile boolean hashValid = false;

        TestStatusImpl(TestStatusBuilder base) {
            super(base.augmentation);
            this._execStatus = base.getExecStatus();
            this._testsCompleted = base.getTestsCompleted();
        }

        @Override
        public TestStatus.ExecStatus getExecStatus() {
            return this._execStatus;
        }

        @Override
        public Uint32 getTestsCompleted() {
            return this._testsCompleted;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._execStatus);
            result = 31 * result + Objects.hashCode(this._testsCompleted);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!TestStatus.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            TestStatus other = (TestStatus)obj;
            if (!Objects.equals((Object)this._execStatus, (Object)other.getExecStatus())) {
                return false;
            }
            if (!Objects.equals(this._testsCompleted, other.getTestsCompleted())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TestStatusImpl otherImpl = (TestStatusImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"TestStatus");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_execStatus", (Object)((Object)this._execStatus));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_testsCompleted", (Object)this._testsCompleted);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

