/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.cardinal.openflow.rev161128.cardinalopenflowinfogrouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.cardinal.openflow.rev161128.cardinalopenflowinfogrouping.Openflow;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OpenflowBuilder
implements Builder<Openflow> {
    private String _flowStats;
    private String _interface;
    private String _macAddress;
    private String _manufacturer;
    private String _meterStats;
    private String _nodeName;
    private String _status;
    Map<Class<? extends Augmentation<Openflow>>, Augmentation<Openflow>> augmentation = Collections.emptyMap();

    public OpenflowBuilder() {
    }

    public OpenflowBuilder(Openflow base) {
        AugmentationHolder casted;
        this._flowStats = base.getFlowStats();
        this._interface = base.getInterface();
        this._macAddress = base.getMacAddress();
        this._manufacturer = base.getManufacturer();
        this._meterStats = base.getMeterStats();
        this._nodeName = base.getNodeName();
        this._status = base.getStatus();
        if (base instanceof OpenflowImpl) {
            OpenflowImpl impl = (OpenflowImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Openflow>>, Augmentation<Openflow>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Openflow>>, Augmentation<Openflow>>(casted.augmentations());
        }
    }

    public String getFlowStats() {
        return this._flowStats;
    }

    public String getInterface() {
        return this._interface;
    }

    public String getMacAddress() {
        return this._macAddress;
    }

    public String getManufacturer() {
        return this._manufacturer;
    }

    public String getMeterStats() {
        return this._meterStats;
    }

    public String getNodeName() {
        return this._nodeName;
    }

    public String getStatus() {
        return this._status;
    }

    public <E extends Augmentation<Openflow>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public OpenflowBuilder setFlowStats(String value) {
        this._flowStats = value;
        return this;
    }

    public OpenflowBuilder setInterface(String value) {
        this._interface = value;
        return this;
    }

    public OpenflowBuilder setMacAddress(String value) {
        this._macAddress = value;
        return this;
    }

    public OpenflowBuilder setManufacturer(String value) {
        this._manufacturer = value;
        return this;
    }

    public OpenflowBuilder setMeterStats(String value) {
        this._meterStats = value;
        return this;
    }

    public OpenflowBuilder setNodeName(String value) {
        this._nodeName = value;
        return this;
    }

    public OpenflowBuilder setStatus(String value) {
        this._status = value;
        return this;
    }

    public OpenflowBuilder addAugmentation(Class<? extends Augmentation<Openflow>> augmentationType, Augmentation<Openflow> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Openflow>>, Augmentation<Openflow>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public OpenflowBuilder removeAugmentation(Class<? extends Augmentation<Openflow>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Openflow build() {
        return new OpenflowImpl(this);
    }

    private static final class OpenflowImpl
    implements Openflow {
        private final String _flowStats;
        private final String _interface;
        private final String _macAddress;
        private final String _manufacturer;
        private final String _meterStats;
        private final String _nodeName;
        private final String _status;
        private Map<Class<? extends Augmentation<Openflow>>, Augmentation<Openflow>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Openflow> getImplementedInterface() {
            return Openflow.class;
        }

        private OpenflowImpl(OpenflowBuilder base) {
            this._flowStats = base.getFlowStats();
            this._interface = base.getInterface();
            this._macAddress = base.getMacAddress();
            this._manufacturer = base.getManufacturer();
            this._meterStats = base.getMeterStats();
            this._nodeName = base.getNodeName();
            this._status = base.getStatus();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Openflow>>, Augmentation<Openflow>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Openflow>>, Augmentation<Openflow>>(base.augmentation);
                }
            }
        }

        @Override
        public String getFlowStats() {
            return this._flowStats;
        }

        @Override
        public String getInterface() {
            return this._interface;
        }

        @Override
        public String getMacAddress() {
            return this._macAddress;
        }

        @Override
        public String getManufacturer() {
            return this._manufacturer;
        }

        @Override
        public String getMeterStats() {
            return this._meterStats;
        }

        @Override
        public String getNodeName() {
            return this._nodeName;
        }

        @Override
        public String getStatus() {
            return this._status;
        }

        public <E extends Augmentation<Openflow>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._flowStats);
            result = 31 * result + Objects.hashCode(this._interface);
            result = 31 * result + Objects.hashCode(this._macAddress);
            result = 31 * result + Objects.hashCode(this._manufacturer);
            result = 31 * result + Objects.hashCode(this._meterStats);
            result = 31 * result + Objects.hashCode(this._nodeName);
            result = 31 * result + Objects.hashCode(this._status);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Openflow.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Openflow other = (Openflow)obj;
            if (!Objects.equals(this._flowStats, other.getFlowStats())) {
                return false;
            }
            if (!Objects.equals(this._interface, other.getInterface())) {
                return false;
            }
            if (!Objects.equals(this._macAddress, other.getMacAddress())) {
                return false;
            }
            if (!Objects.equals(this._manufacturer, other.getManufacturer())) {
                return false;
            }
            if (!Objects.equals(this._meterStats, other.getMeterStats())) {
                return false;
            }
            if (!Objects.equals(this._nodeName, other.getNodeName())) {
                return false;
            }
            if (!Objects.equals(this._status, other.getStatus())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                OpenflowImpl otherImpl = (OpenflowImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Openflow>>, Augmentation<Openflow>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Openflow [";
            StringBuilder builder = new StringBuilder(name);
            if (this._flowStats != null) {
                builder.append("_flowStats=");
                builder.append(this._flowStats);
                builder.append(", ");
            }
            if (this._interface != null) {
                builder.append("_interface=");
                builder.append(this._interface);
                builder.append(", ");
            }
            if (this._macAddress != null) {
                builder.append("_macAddress=");
                builder.append(this._macAddress);
                builder.append(", ");
            }
            if (this._manufacturer != null) {
                builder.append("_manufacturer=");
                builder.append(this._manufacturer);
                builder.append(", ");
            }
            if (this._meterStats != null) {
                builder.append("_meterStats=");
                builder.append(this._meterStats);
                builder.append(", ");
            }
            if (this._nodeName != null) {
                builder.append("_nodeName=");
                builder.append(this._nodeName);
                builder.append(", ");
            }
            if (this._status != null) {
                builder.append("_status=");
                builder.append(this._status);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

