/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.ConfigType;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.SetSubdomainConfigInput;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.BfrId;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.BierSubdomain;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.Bsl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.IgpType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.MtId;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.SubDomainId;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.bier.subdomain.Af;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SetSubdomainConfigInputBuilder
implements Builder<SetSubdomainConfigInput> {
    private Af _af;
    private BfrId _bfrId;
    private Bsl _bitstringlength;
    private Integer _domainId;
    private IgpType _igpType;
    private MtId _mtId;
    private String _nodeName;
    private SubDomainId _subDomainId;
    private ConfigType _writeType;
    Map<Class<? extends Augmentation<SetSubdomainConfigInput>>, Augmentation<SetSubdomainConfigInput>> augmentation = Collections.emptyMap();

    public SetSubdomainConfigInputBuilder() {
    }

    public SetSubdomainConfigInputBuilder(BierSubdomain arg) {
        this._subDomainId = arg.getSubDomainId();
        this._igpType = arg.getIgpType();
        this._mtId = arg.getMtId();
        this._bfrId = arg.getBfrId();
        this._bitstringlength = arg.getBitstringlength();
        this._af = arg.getAf();
    }

    public SetSubdomainConfigInputBuilder(SetSubdomainConfigInput base) {
        AugmentationHolder casted;
        this._af = base.getAf();
        this._bfrId = base.getBfrId();
        this._bitstringlength = base.getBitstringlength();
        this._domainId = base.getDomainId();
        this._igpType = base.getIgpType();
        this._mtId = base.getMtId();
        this._nodeName = base.getNodeName();
        this._subDomainId = base.getSubDomainId();
        this._writeType = base.getWriteType();
        if (base instanceof SetSubdomainConfigInputImpl) {
            SetSubdomainConfigInputImpl impl = (SetSubdomainConfigInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SetSubdomainConfigInput>>, Augmentation<SetSubdomainConfigInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SetSubdomainConfigInput>>, Augmentation<SetSubdomainConfigInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BierSubdomain) {
            this._subDomainId = ((BierSubdomain)arg).getSubDomainId();
            this._igpType = ((BierSubdomain)arg).getIgpType();
            this._mtId = ((BierSubdomain)arg).getMtId();
            this._bfrId = ((BierSubdomain)arg).getBfrId();
            this._bitstringlength = ((BierSubdomain)arg).getBitstringlength();
            this._af = ((BierSubdomain)arg).getAf();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.BierSubdomain] \nbut was: " + arg);
        }
    }

    public Af getAf() {
        return this._af;
    }

    public BfrId getBfrId() {
        return this._bfrId;
    }

    public Bsl getBitstringlength() {
        return this._bitstringlength;
    }

    public Integer getDomainId() {
        return this._domainId;
    }

    public IgpType getIgpType() {
        return this._igpType;
    }

    public MtId getMtId() {
        return this._mtId;
    }

    public String getNodeName() {
        return this._nodeName;
    }

    public SubDomainId getSubDomainId() {
        return this._subDomainId;
    }

    public ConfigType getWriteType() {
        return this._writeType;
    }

    public <E extends Augmentation<SetSubdomainConfigInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public SetSubdomainConfigInputBuilder setAf(Af value) {
        this._af = value;
        return this;
    }

    public SetSubdomainConfigInputBuilder setBfrId(BfrId value) {
        this._bfrId = value;
        return this;
    }

    public SetSubdomainConfigInputBuilder setBitstringlength(Bsl value) {
        this._bitstringlength = value;
        return this;
    }

    private static void checkDomainIdRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..65535]].", value));
    }

    public SetSubdomainConfigInputBuilder setDomainId(Integer value) {
        if (value != null) {
            SetSubdomainConfigInputBuilder.checkDomainIdRange(value);
        }
        this._domainId = value;
        return this;
    }

    public SetSubdomainConfigInputBuilder setIgpType(IgpType value) {
        this._igpType = value;
        return this;
    }

    public SetSubdomainConfigInputBuilder setMtId(MtId value) {
        this._mtId = value;
        return this;
    }

    public SetSubdomainConfigInputBuilder setNodeName(String value) {
        this._nodeName = value;
        return this;
    }

    public SetSubdomainConfigInputBuilder setSubDomainId(SubDomainId value) {
        this._subDomainId = value;
        return this;
    }

    public SetSubdomainConfigInputBuilder setWriteType(ConfigType value) {
        this._writeType = value;
        return this;
    }

    public SetSubdomainConfigInputBuilder addAugmentation(Class<? extends Augmentation<SetSubdomainConfigInput>> augmentationType, Augmentation<SetSubdomainConfigInput> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SetSubdomainConfigInput>>, Augmentation<SetSubdomainConfigInput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SetSubdomainConfigInputBuilder removeAugmentation(Class<? extends Augmentation<SetSubdomainConfigInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public SetSubdomainConfigInput build() {
        return new SetSubdomainConfigInputImpl(this);
    }

    private static final class SetSubdomainConfigInputImpl
    implements SetSubdomainConfigInput {
        private final Af _af;
        private final BfrId _bfrId;
        private final Bsl _bitstringlength;
        private final Integer _domainId;
        private final IgpType _igpType;
        private final MtId _mtId;
        private final String _nodeName;
        private final SubDomainId _subDomainId;
        private final ConfigType _writeType;
        private Map<Class<? extends Augmentation<SetSubdomainConfigInput>>, Augmentation<SetSubdomainConfigInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<SetSubdomainConfigInput> getImplementedInterface() {
            return SetSubdomainConfigInput.class;
        }

        private SetSubdomainConfigInputImpl(SetSubdomainConfigInputBuilder base) {
            this._af = base.getAf();
            this._bfrId = base.getBfrId();
            this._bitstringlength = base.getBitstringlength();
            this._domainId = base.getDomainId();
            this._igpType = base.getIgpType();
            this._mtId = base.getMtId();
            this._nodeName = base.getNodeName();
            this._subDomainId = base.getSubDomainId();
            this._writeType = base.getWriteType();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<SetSubdomainConfigInput>>, Augmentation<SetSubdomainConfigInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<SetSubdomainConfigInput>>, Augmentation<SetSubdomainConfigInput>>(base.augmentation);
                }
            }
        }

        public Af getAf() {
            return this._af;
        }

        public BfrId getBfrId() {
            return this._bfrId;
        }

        public Bsl getBitstringlength() {
            return this._bitstringlength;
        }

        @Override
        public Integer getDomainId() {
            return this._domainId;
        }

        public IgpType getIgpType() {
            return this._igpType;
        }

        public MtId getMtId() {
            return this._mtId;
        }

        @Override
        public String getNodeName() {
            return this._nodeName;
        }

        public SubDomainId getSubDomainId() {
            return this._subDomainId;
        }

        @Override
        public ConfigType getWriteType() {
            return this._writeType;
        }

        public <E extends Augmentation<SetSubdomainConfigInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._af);
            result = 31 * result + Objects.hashCode(this._bfrId);
            result = 31 * result + Objects.hashCode(this._bitstringlength);
            result = 31 * result + Objects.hashCode(this._domainId);
            result = 31 * result + Objects.hashCode(this._igpType);
            result = 31 * result + Objects.hashCode(this._mtId);
            result = 31 * result + Objects.hashCode(this._nodeName);
            result = 31 * result + Objects.hashCode(this._subDomainId);
            result = 31 * result + Objects.hashCode((Object)this._writeType);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SetSubdomainConfigInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SetSubdomainConfigInput other = (SetSubdomainConfigInput)obj;
            if (!Objects.equals(this._af, other.getAf())) {
                return false;
            }
            if (!Objects.equals(this._bfrId, other.getBfrId())) {
                return false;
            }
            if (!Objects.equals(this._bitstringlength, other.getBitstringlength())) {
                return false;
            }
            if (!Objects.equals(this._domainId, other.getDomainId())) {
                return false;
            }
            if (!Objects.equals(this._igpType, other.getIgpType())) {
                return false;
            }
            if (!Objects.equals(this._mtId, other.getMtId())) {
                return false;
            }
            if (!Objects.equals(this._nodeName, other.getNodeName())) {
                return false;
            }
            if (!Objects.equals(this._subDomainId, other.getSubDomainId())) {
                return false;
            }
            if (!Objects.equals((Object)this._writeType, (Object)other.getWriteType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SetSubdomainConfigInputImpl otherImpl = (SetSubdomainConfigInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SetSubdomainConfigInput>>, Augmentation<SetSubdomainConfigInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "SetSubdomainConfigInput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._af != null) {
                builder.append("_af=");
                builder.append(this._af);
                builder.append(", ");
            }
            if (this._bfrId != null) {
                builder.append("_bfrId=");
                builder.append(this._bfrId);
                builder.append(", ");
            }
            if (this._bitstringlength != null) {
                builder.append("_bitstringlength=");
                builder.append(this._bitstringlength);
                builder.append(", ");
            }
            if (this._domainId != null) {
                builder.append("_domainId=");
                builder.append(this._domainId);
                builder.append(", ");
            }
            if (this._igpType != null) {
                builder.append("_igpType=");
                builder.append(this._igpType);
                builder.append(", ");
            }
            if (this._mtId != null) {
                builder.append("_mtId=");
                builder.append(this._mtId);
                builder.append(", ");
            }
            if (this._nodeName != null) {
                builder.append("_nodeName=");
                builder.append(this._nodeName);
                builder.append(", ");
            }
            if (this._subDomainId != null) {
                builder.append("_subDomainId=");
                builder.append(this._subDomainId);
                builder.append(", ");
            }
            if (this._writeType != null) {
                builder.append("_writeType=");
                builder.append((Object)this._writeType);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

