/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.ConfigType;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.SetLabelRangeInput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SetLabelRangeInputBuilder
implements Builder<SetLabelRangeInput> {
    private Long _lableBase;
    private Long _lableRange;
    private String _nodeName;
    private ConfigType _writeType;
    Map<Class<? extends Augmentation<SetLabelRangeInput>>, Augmentation<SetLabelRangeInput>> augmentation = Collections.emptyMap();

    public SetLabelRangeInputBuilder() {
    }

    public SetLabelRangeInputBuilder(SetLabelRangeInput base) {
        AugmentationHolder casted;
        this._lableBase = base.getLableBase();
        this._lableRange = base.getLableRange();
        this._nodeName = base.getNodeName();
        this._writeType = base.getWriteType();
        if (base instanceof SetLabelRangeInputImpl) {
            SetLabelRangeInputImpl impl = (SetLabelRangeInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SetLabelRangeInput>>, Augmentation<SetLabelRangeInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SetLabelRangeInput>>, Augmentation<SetLabelRangeInput>>(casted.augmentations());
        }
    }

    public Long getLableBase() {
        return this._lableBase;
    }

    public Long getLableRange() {
        return this._lableRange;
    }

    public String getNodeName() {
        return this._nodeName;
    }

    public ConfigType getWriteType() {
        return this._writeType;
    }

    public <E extends Augmentation<SetLabelRangeInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkLableBaseRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public SetLabelRangeInputBuilder setLableBase(Long value) {
        if (value != null) {
            SetLabelRangeInputBuilder.checkLableBaseRange(value);
        }
        this._lableBase = value;
        return this;
    }

    private static void checkLableRangeRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public SetLabelRangeInputBuilder setLableRange(Long value) {
        if (value != null) {
            SetLabelRangeInputBuilder.checkLableRangeRange(value);
        }
        this._lableRange = value;
        return this;
    }

    public SetLabelRangeInputBuilder setNodeName(String value) {
        this._nodeName = value;
        return this;
    }

    public SetLabelRangeInputBuilder setWriteType(ConfigType value) {
        this._writeType = value;
        return this;
    }

    public SetLabelRangeInputBuilder addAugmentation(Class<? extends Augmentation<SetLabelRangeInput>> augmentationType, Augmentation<SetLabelRangeInput> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SetLabelRangeInput>>, Augmentation<SetLabelRangeInput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SetLabelRangeInputBuilder removeAugmentation(Class<? extends Augmentation<SetLabelRangeInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public SetLabelRangeInput build() {
        return new SetLabelRangeInputImpl(this);
    }

    private static final class SetLabelRangeInputImpl
    implements SetLabelRangeInput {
        private final Long _lableBase;
        private final Long _lableRange;
        private final String _nodeName;
        private final ConfigType _writeType;
        private Map<Class<? extends Augmentation<SetLabelRangeInput>>, Augmentation<SetLabelRangeInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<SetLabelRangeInput> getImplementedInterface() {
            return SetLabelRangeInput.class;
        }

        private SetLabelRangeInputImpl(SetLabelRangeInputBuilder base) {
            this._lableBase = base.getLableBase();
            this._lableRange = base.getLableRange();
            this._nodeName = base.getNodeName();
            this._writeType = base.getWriteType();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<SetLabelRangeInput>>, Augmentation<SetLabelRangeInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<SetLabelRangeInput>>, Augmentation<SetLabelRangeInput>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getLableBase() {
            return this._lableBase;
        }

        @Override
        public Long getLableRange() {
            return this._lableRange;
        }

        @Override
        public String getNodeName() {
            return this._nodeName;
        }

        @Override
        public ConfigType getWriteType() {
            return this._writeType;
        }

        public <E extends Augmentation<SetLabelRangeInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._lableBase);
            result = 31 * result + Objects.hashCode(this._lableRange);
            result = 31 * result + Objects.hashCode(this._nodeName);
            result = 31 * result + Objects.hashCode((Object)this._writeType);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SetLabelRangeInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SetLabelRangeInput other = (SetLabelRangeInput)obj;
            if (!Objects.equals(this._lableBase, other.getLableBase())) {
                return false;
            }
            if (!Objects.equals(this._lableRange, other.getLableRange())) {
                return false;
            }
            if (!Objects.equals(this._nodeName, other.getNodeName())) {
                return false;
            }
            if (!Objects.equals((Object)this._writeType, (Object)other.getWriteType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SetLabelRangeInputImpl otherImpl = (SetLabelRangeInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SetLabelRangeInput>>, Augmentation<SetLabelRangeInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "SetLabelRangeInput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._lableBase != null) {
                builder.append("_lableBase=");
                builder.append(this._lableBase);
                builder.append(", ");
            }
            if (this._lableRange != null) {
                builder.append("_lableRange=");
                builder.append(this._lableRange);
                builder.append(", ");
            }
            if (this._nodeName != null) {
                builder.append("_nodeName=");
                builder.append(this._nodeName);
                builder.append(", ");
            }
            if (this._writeType != null) {
                builder.append("_writeType=");
                builder.append((Object)this._writeType);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

